/*
 * Decompiled with CFR 0.152.
 */
package zsawyer.mods.mumblelink.mumble;

import net.minecraft.client.Minecraft;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import zsawyer.mods.mumblelink.MumbleLinkImpl;
import zsawyer.mods.mumblelink.error.NativeUpdateErrorHandler;
import zsawyer.mods.mumblelink.mumble.jna.LinkAPIHelper;
import zsawyer.mods.mumblelink.util.json.JSONException;
import zsawyer.mods.mumblelink.util.json.JSONObject;
import zsawyer.mumble.jna.LinkAPILibrary;

public class UpdateData {
    float[] fAvatarPosition = new float[]{0.0f, 0.0f, 0.0f};
    float[] fAvatarFront = new float[]{0.0f, 0.0f, 0.0f};
    float[] fAvatarTop = new float[]{0.0f, 0.0f, 0.0f};
    String name = "";
    String description = "";
    float[] fCameraPosition = new float[]{0.0f, 0.0f, 0.0f};
    float[] fCameraFront = new float[]{0.0f, 0.0f, 0.0f};
    float[] fCameraTop = new float[]{0.0f, 0.0f, 0.0f};
    String identity = "";
    String context = "";
    LinkAPILibrary mumbleLink;
    NativeUpdateErrorHandler errorHandler;
    private int uiTick = 0;

    public UpdateData(LinkAPILibrary mumbleLink, NativeUpdateErrorHandler errorHandler) {
        this.mumbleLink = mumbleLink;
        this.errorHandler = errorHandler;
        this.name = "Minecraft";
        this.description = "Link plugin for Minecraft with ModLoader";
    }

    public void send() {
        boolean success;
        LinkAPILibrary.LinkedMem lm = new LinkAPILibrary.LinkedMem();
        lm.identity = LinkAPIHelper.parseToCharBuffer(256, this.identity).array();
        lm.context = LinkAPIHelper.parseToByteBuffer(256, this.context).array();
        lm.context_len = this.context.length();
        lm.name = LinkAPIHelper.parseToCharBuffer(256, this.name).array();
        lm.description = LinkAPIHelper.parseToCharBuffer(2048, this.description).array();
        lm.uiTick = ++this.uiTick;
        lm.uiVersion = 2;
        lm.fAvatarPosition = this.fAvatarPosition;
        lm.fAvatarFront = this.fAvatarFront;
        lm.fAvatarTop = this.fAvatarTop;
        lm.fCameraPosition = this.fCameraPosition;
        lm.fCameraFront = this.fCameraFront;
        lm.fCameraTop = this.fCameraTop;
        byte successMessage = this.mumbleLink.updateData(lm);
        boolean bl = success = successMessage != 0;
        if (!success) {
            this.errorHandler.handleError(NativeUpdateErrorHandler.NativeUpdateError.ERROR_NOT_YET_INITIALIZED);
        }
    }

    public void set(Minecraft game) {
        try {
            float fAvatarFrontX = 1.0f;
            float fAvatarFrontY = 1.0f;
            float fAvatarFrontZ = 1.0f;
            float fCameraFrontX = 1.0f;
            float fCameraFrontY = 1.0f;
            float fCameraFrontZ = 1.0f;
            float fAvatarTopX = 1.0f;
            float fAvatarTopY = 1.0f;
            float fAvatarTopZ = 1.0f;
            float fCameraTopX = 1.0f;
            float fCameraTopY = 1.0f;
            float fCameraTopZ = 1.0f;
            Vec3 lookDirection = game.field_71439_g.func_70040_Z();
            Vec3 topDirection = this.getTopVec(game);
            this.fAvatarPosition = new float[]{Float.parseFloat(Double.toString(game.field_71439_g.field_70165_t)), Float.parseFloat(Double.toString(game.field_71439_g.field_70161_v)), Float.parseFloat(Double.toString(game.field_71439_g.field_70163_u))};
            this.fAvatarFront = new float[]{Float.parseFloat(Double.toString(lookDirection.field_72450_a * (double)fAvatarFrontX)), Float.parseFloat(Double.toString(lookDirection.field_72449_c * (double)fAvatarFrontZ)), Float.parseFloat(Double.toString(lookDirection.field_72448_b * (double)fAvatarFrontY))};
            this.fAvatarTop = new float[]{Float.parseFloat(Double.toString(topDirection.field_72450_a * (double)fAvatarTopX)), Float.parseFloat(Double.toString(topDirection.field_72449_c * (double)fAvatarTopZ)), Float.parseFloat(Double.toString(topDirection.field_72448_b * (double)fAvatarTopY))};
            this.fCameraPosition = new float[]{Float.parseFloat(Double.toString(game.field_71439_g.field_70165_t)), Float.parseFloat(Double.toString(game.field_71439_g.field_70161_v)), Float.parseFloat(Double.toString(game.field_71439_g.field_70163_u))};
            this.fCameraFront = new float[]{Float.parseFloat(Double.toString(lookDirection.field_72450_a * (double)fCameraFrontX)), Float.parseFloat(Double.toString(lookDirection.field_72449_c * (double)fCameraFrontZ)), Float.parseFloat(Double.toString(lookDirection.field_72448_b * (double)fCameraFrontY))};
            this.fCameraTop = new float[]{Float.parseFloat(Double.toString(topDirection.field_72450_a * (double)fCameraTopX)), Float.parseFloat(Double.toString(topDirection.field_72449_c * (double)fCameraTopZ)), Float.parseFloat(Double.toString(topDirection.field_72448_b * (double)fCameraTopY))};
            this.identity = this.generateIdentity(game, 256);
            this.context = this.generateContext(game, 256);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String generateIdentity(Minecraft game, int maxLength) {
        String displayName = game.field_71439_g.getDisplayNameString();
        try {
            JSONObject newIdentity = new JSONObject();
            newIdentity.put("name", displayName);
            return newIdentity.toString();
        }
        catch (JSONException e) {
            MumbleLinkImpl.LOG.fatal("could not generate identity", (Throwable)e);
            return displayName;
        }
    }

    protected String generateContext(Minecraft game, int maxLength) {
        try {
            JSONObject newContext = new JSONObject();
            newContext.put("domain", "AllTalk");
            return newContext.toString();
        }
        catch (JSONException e) {
            MumbleLinkImpl.LOG.fatal("could not generate context", (Throwable)e);
            return "AllTalk";
        }
    }

    private Vec3 getTopVec(Minecraft game) {
        float f1 = MathHelper.func_76134_b((float)(-game.field_71439_g.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-game.field_71439_g.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)((-game.field_71439_g.field_70125_A + 90.0f) * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)((-game.field_71439_g.field_70125_A + 90.0f) * ((float)Math.PI / 180)));
        return new Vec3((double)(f2 * f3), (double)f4, (double)(f1 * f3));
    }
}

