/*
 * Decompiled with CFR 0.152.
 */
package zsawyer.mods.mumblelink.notification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import zsawyer.mods.mumblelink.notification.ChatNotifier;

public class BufferedChatNotifier
extends ChatNotifier
implements Runnable {
    List<String> messages = Collections.synchronizedList(new ArrayList());
    Thread keepTrying = new Thread(this);

    public BufferedChatNotifier(Minecraft game) {
        super(game);
    }

    @Override
    public void print(String message) {
        this.messages.add(message);
        this.startTryingToSend();
    }

    @Override
    public void run() {
        this.waitUntilSendingPossible();
        this.sendAllMessages();
    }

    private void startTryingToSend() {
        if (this.canSendMessage()) {
            this.sendAllMessages();
        } else {
            try {
                this.keepTrying.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    private void sendAllMessages() {
        Iterator<String> messageCrawler = this.messages.iterator();
        while (messageCrawler.hasNext()) {
            String message = messageCrawler.next();
            this.send(message);
            messageCrawler.remove();
        }
    }

    private void waitUntilSendingPossible() {
        while (!this.canSendMessage()) {
            Thread.yield();
        }
    }
}

