/*
 * Decompiled with CFR 0.152.
 */
package org.freeforums.geforce.securitycraft.handlers;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import org.freeforums.geforce.securitycraft.blocks.BlockLaserBlock;
import org.freeforums.geforce.securitycraft.main.HelpfulMethods;
import org.freeforums.geforce.securitycraft.main.mod_SecurityCraft;
import org.freeforums.geforce.securitycraft.network.packets.PacketCheckRetinalScanner;
import org.freeforums.geforce.securitycraft.tileentity.CustomizableSCTE;
import org.freeforums.geforce.securitycraft.tileentity.TileEntityKeypadChest;
import org.freeforums.geforce.securitycraft.tileentity.TileEntityOwnable;
import org.freeforums.geforce.securitycraft.tileentity.TileEntityPortableRadar;
import org.freeforums.geforce.securitycraft.tileentity.TileEntityReinforcedDoor;

public class ForgeEventHandler {
    private int counter = 0;
    private int cooldownCounter = 0;

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ChatComponentTranslation chatcomponenttranslation = new ChatComponentTranslation("Thanks for using SecurityCraft " + mod_SecurityCraft.getVersion() + "! Tip: " + this.getRandomTip(), new Object[0]);
        if (mod_SecurityCraft.configHandler.sayThanksMessage) {
            event.player.func_146105_b((IChatComponent)chatcomponenttranslation);
        }
    }

    private String getRandomTip() {
        Random random = new Random();
        int randomInt = random.nextInt(4);
        if (randomInt == 0) {
            return "Check out " + EnumChatFormatting.ITALIC + "geforce.freeforums.org" + EnumChatFormatting.RESET + " for new updates, news, reporting bugs, and more!";
        }
        if (randomInt == 1) {
            return "Use the command '/sc' to get information on different things this mod adds. /sc recipe laserblock will display the recipe for the laser block.";
        }
        if (randomInt == 2) {
            return "Use the command '/sc' to get information on different things this mod adds. /sc help codebreaker will display a description on the codebreaker.";
        }
        if (randomInt == 3) {
            return "Join my IRC channel " + EnumChatFormatting.ITALIC + "#GeforceMods" + EnumChatFormatting.RESET + " on EsperNet to chat with me for support and discussion on mods I have made.";
        }
        return "";
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderGameOverlay(RenderGameOverlayEvent event) {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ++this.counter;
        if (this.cooldownCounter > 0) {
            --this.cooldownCounter;
        }
        if (this.counter >= 20) {
            mod_SecurityCraft.network.sendToServer((IMessage)new PacketCheckRetinalScanner(event.player.func_70005_c_()));
            this.counter = 0;
        }
    }

    @SubscribeEvent
    public void onBucketUsed(FillBucketEvent event) {
        ItemStack result = this.fillBucket(event.world, event.target);
        if (result == null) {
            return;
        }
        event.result = result;
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (mod_SecurityCraft.configHandler.disconnectOnWorldClose && mod_SecurityCraft.instance.getIrcBot() != null) {
            mod_SecurityCraft.instance.getIrcBot().disconnect();
            mod_SecurityCraft.instance.setIrcBot(null);
        }
    }

    @SubscribeEvent
    public void onPlayerInteracted(PlayerInteractEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && this.isCustomizableBlock(event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z)) && event.entityPlayer.func_71045_bC() != null && event.entityPlayer.func_71045_bC().func_77973_b() == mod_SecurityCraft.universalBlockModifier) {
            event.setCanceled(true);
            if (((CustomizableSCTE)event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z)).getOwnerUUID() != null && !((CustomizableSCTE)event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z)).getOwnerUUID().matches(event.entityPlayer.func_146103_bH().getId().toString())) {
                HelpfulMethods.sendMessageToPlayer(event.entityPlayer, "I'm sorry, you can not customize this block. This block is owned by " + ((TileEntityOwnable)event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z)).getOwnerName() + ".", EnumChatFormatting.RED);
                return;
            }
            event.entityPlayer.openGui((Object)mod_SecurityCraft.instance, 100, event.entityPlayer.field_70170_p, event.x, event.y, event.z);
            return;
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == mod_SecurityCraft.portableRadar && event.entityPlayer.func_71045_bC() != null && event.entityPlayer.func_71045_bC().func_77973_b() == Items.field_151057_cb && event.entityPlayer.func_71045_bC().func_82837_s()) {
            event.setCanceled(true);
            --event.entityPlayer.func_71045_bC().field_77994_a;
            ((TileEntityPortableRadar)event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z)).setCustomName(event.entityPlayer.func_71045_bC().func_82833_r());
            return;
        }
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && this.isOwnableBlock(event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z)) && event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z) != null && event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z) instanceof TileEntityOwnable && event.entityPlayer.func_71045_bC() != null && event.entityPlayer.func_71045_bC().func_77973_b() == mod_SecurityCraft.universalBlockRemover) {
            event.setCanceled(true);
            if (((TileEntityOwnable)event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z)).getOwnerUUID() != null && !((TileEntityOwnable)event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z)).getOwnerUUID().matches(event.entityPlayer.func_146103_bH().getId().toString())) {
                HelpfulMethods.sendMessageToPlayer(event.entityPlayer, "I'm sorry, you can not remove this block. This block is owned by " + ((TileEntityOwnable)event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z)).getOwnerName() + ".", EnumChatFormatting.RED);
                return;
            }
            if (event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == mod_SecurityCraft.doorIndestructableIron) {
                this.checkForReinforcedDoor(event.entityPlayer.field_70170_p, event.x, event.y, event.z, event.entityPlayer);
            } else if (event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == mod_SecurityCraft.LaserBlock) {
                event.entityPlayer.field_70170_p.func_147480_a(event.x, event.y, event.z, true);
                BlockLaserBlock.destroyAdjecentLasers(event.world, event.x, event.y, event.z);
                event.entityPlayer.func_71045_bC().func_77972_a(1, (EntityLivingBase)event.entityPlayer);
            } else {
                event.entityPlayer.field_70170_p.func_147480_a(event.x, event.y, event.z, true);
                event.entityPlayer.field_70170_p.func_147475_p(event.x, event.y, event.z);
                event.entityPlayer.func_71045_bC().func_77972_a(1, (EntityLivingBase)event.entityPlayer);
            }
        } else if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && this.isOwnableBlock(event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z)) && event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z) != null && event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z) instanceof TileEntityKeypadChest && event.entityPlayer.func_71045_bC() != null && event.entityPlayer.func_71045_bC().func_77973_b() == mod_SecurityCraft.universalBlockRemover) {
            event.setCanceled(true);
            if (((TileEntityKeypadChest)event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z)).getOwnerUUID() != null && !((TileEntityKeypadChest)event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z)).getOwnerUUID().matches(event.entityPlayer.func_146103_bH().getId().toString())) {
                HelpfulMethods.sendMessageToPlayer(event.entityPlayer, "I'm sorry, you can not remove this block. This block is owned by " + ((TileEntityKeypadChest)event.entityPlayer.field_70170_p.func_147438_o(event.x, event.y, event.z)).getOwnerName() + ".", EnumChatFormatting.RED);
                return;
            }
            event.entityPlayer.field_70170_p.func_147480_a(event.x, event.y, event.z, true);
            event.entityPlayer.field_70170_p.func_147475_p(event.x, event.y, event.z);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("securitycraft")) {
            mod_SecurityCraft.configFile.save();
        }
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (!event.world.field_72995_K && event.world.func_147438_o(event.x, event.y, event.z) != null && event.world.func_147438_o(event.x, event.y, event.z) instanceof CustomizableSCTE) {
            for (int i = 0; i < ((CustomizableSCTE)event.world.func_147438_o(event.x, event.y, event.z)).getNumberOfCustomizableOptions(); ++i) {
                if (((CustomizableSCTE)event.world.func_147438_o((int)event.x, (int)event.y, (int)event.z)).itemStacks[i] == null) continue;
                EntityItem item = new EntityItem(event.world, (double)event.x, (double)event.y, (double)event.z, ((CustomizableSCTE)event.world.func_147438_o((int)event.x, (int)event.y, (int)event.z)).itemStacks[i]);
                event.world.func_72838_d((Entity)item);
            }
        }
    }

    private ItemStack fillBucket(World world, MovingObjectPosition position) {
        Block block = world.func_147439_a(position.field_72311_b, position.field_72312_c, position.field_72309_d);
        if (block == mod_SecurityCraft.bogusWater) {
            world.func_147468_f(position.field_72311_b, position.field_72312_c, position.field_72309_d);
            return new ItemStack(mod_SecurityCraft.fWaterBucket, 1);
        }
        if (block == mod_SecurityCraft.bogusLava) {
            world.func_147468_f(position.field_72311_b, position.field_72312_c, position.field_72309_d);
            return new ItemStack(mod_SecurityCraft.fLavaBucket, 1);
        }
        return null;
    }

    private int[] getBlockInFront(World par1World, EntityPlayer par2EntityPlayer, double reach) {
        int[] blockInfo = new int[]{0, 0, 0, 0, -1, 0};
        MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(par1World, par2EntityPlayer, true, reach);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            blockInfo[1] = movingobjectposition.field_72311_b;
            blockInfo[2] = movingobjectposition.field_72312_c;
            blockInfo[3] = movingobjectposition.field_72309_d;
            blockInfo[4] = movingobjectposition.field_72310_e;
            blockInfo[5] = par1World.func_72805_g(blockInfo[1], blockInfo[2], blockInfo[3]);
            blockInfo[0] = Block.func_149682_b((Block)par1World.func_147439_a(blockInfo[1], blockInfo[2], blockInfo[3]));
        }
        return blockInfo;
    }

    private MovingObjectPosition getMovingObjectPositionFromPlayer(World par1World, EntityPlayer par2EntityPlayer, boolean flag, double reach) {
        float f = 1.0f;
        float playerPitch = par2EntityPlayer.field_70127_C + (par2EntityPlayer.field_70125_A - par2EntityPlayer.field_70127_C) * f;
        float playerYaw = par2EntityPlayer.field_70126_B + (par2EntityPlayer.field_70177_z - par2EntityPlayer.field_70126_B) * f;
        double playerPosX = par2EntityPlayer.field_70169_q + (par2EntityPlayer.field_70165_t - par2EntityPlayer.field_70169_q) * (double)f;
        double playerPosY = par2EntityPlayer.field_70167_r + (par2EntityPlayer.field_70163_u - par2EntityPlayer.field_70167_r) * (double)f + 1.62 - (double)par2EntityPlayer.field_70129_M;
        double playerPosZ = par2EntityPlayer.field_70166_s + (par2EntityPlayer.field_70161_v - par2EntityPlayer.field_70166_s) * (double)f;
        Vec3 vecPlayer = Vec3.func_72443_a((double)playerPosX, (double)playerPosY, (double)playerPosZ);
        float cosYaw = MathHelper.func_76134_b((float)(-playerYaw * 0.01745329f - 3.141593f));
        float sinYaw = MathHelper.func_76126_a((float)(-playerYaw * 0.01745329f - 3.141593f));
        float cosPitch = -MathHelper.func_76134_b((float)(-playerPitch * 0.01745329f));
        float sinPitch = -MathHelper.func_76126_a((float)(-playerPitch * 0.01745329f));
        float pointX = sinYaw * cosPitch;
        float pointY = sinPitch;
        float pointZ = cosYaw * cosPitch;
        Vec3 vecPoint = vecPlayer.func_72441_c((double)pointX * reach, (double)pointY * reach, (double)pointZ * reach);
        MovingObjectPosition movingobjectposition = par1World.func_72901_a(vecPlayer, vecPoint, flag);
        return movingobjectposition;
    }

    private void notifyPlayers(String username, EntityPlayer par2EntityPlayer, int par3, int par4, int par5) {
        HelpfulMethods.sendMessageToPlayer(par2EntityPlayer, username + " destroyed a reinforced door with a universal block remover at X: " + par3 + " Y: " + par4 + " Z: " + par5, null);
    }

    private void sendChatMessageTo(EntityPlayer par1EntityPlayer, TileEntityReinforcedDoor TERD) {
        if (TERD.getOwnerUUID() != null) {
            HelpfulMethods.sendMessageToPlayer(par1EntityPlayer, "Im sorry, you can not remove this door. This door is owned by " + TERD.getOwnerName() + ".", EnumChatFormatting.RED);
        }
    }

    private void checkForReinforcedDoor(World par1World, int par2, int par3, int par4, EntityPlayer player) {
        if (par1World.func_72805_g(par2, par3, par4) == 8) {
            TileEntityReinforcedDoor TERD = (TileEntityReinforcedDoor)par1World.func_147438_o(par2, par3, par4);
            TileEntityReinforcedDoor TERD2 = null;
            if (TERD == null) {
                TERD2 = (TileEntityReinforcedDoor)par1World.func_147438_o(par2, par3 + 1, par4);
                if (player.func_70005_c_().matches(TERD2.getOwnerUUID())) {
                    par1World.func_147480_a(par2, par3, par4, false);
                    this.notifyPlayers(player.func_70005_c_(), player, par2, par3, par4);
                    player.func_71045_bC().func_77972_a(1, (EntityLivingBase)player);
                } else {
                    this.sendChatMessageTo(player, TERD2);
                }
                return;
            }
            if (TERD != null && TERD.getOwnerUUID() != null) {
                if (player.func_70005_c_().matches(TERD.getOwnerUUID())) {
                    par1World.func_147480_a(par2, par3, par4, false);
                    this.notifyPlayers(player.func_70005_c_(), player, par2, par3, par4);
                    player.func_71045_bC().func_77972_a(1, (EntityLivingBase)player);
                } else {
                    this.sendChatMessageTo(player, TERD);
                }
            }
        }
    }

    private boolean isOwnableBlock(Block par1Block) {
        return par1Block == mod_SecurityCraft.doorIndestructableIron || par1Block == mod_SecurityCraft.Keypad || par1Block == mod_SecurityCraft.keycardReader || par1Block == mod_SecurityCraft.retinalScanner || par1Block == mod_SecurityCraft.reinforcedGlass || par1Block == mod_SecurityCraft.alarm || par1Block == mod_SecurityCraft.reinforcedStone || par1Block == mod_SecurityCraft.unbreakableIronBars || par1Block == mod_SecurityCraft.reinforcedFencegate || par1Block == mod_SecurityCraft.LaserBlock || par1Block == mod_SecurityCraft.keypadChest || par1Block == mod_SecurityCraft.reinforcedWoodPlanks || par1Block == mod_SecurityCraft.inventoryScanner;
    }

    private boolean isCustomizableBlock(Block par1Block) {
        return par1Block == mod_SecurityCraft.portableRadar || par1Block == mod_SecurityCraft.Keypad || par1Block == mod_SecurityCraft.retinalScanner || par1Block == mod_SecurityCraft.keycardReader || par1Block == mod_SecurityCraft.LaserBlock || par1Block == mod_SecurityCraft.inventoryScanner;
    }

    @SideOnly(value=Side.SERVER)
    public World getServerWorld() {
        return MinecraftServer.func_71276_C().func_130014_f_();
    }

    public Side getSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    public EntityPlayer getPlayerFromName(String par1) {
        List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayer tempPlayer : players) {
            if (!tempPlayer.func_70005_c_().matches(par1)) continue;
            return tempPlayer;
        }
        return null;
    }

    public void setCooldown(int par1) {
        this.cooldownCounter = par1;
    }

    public int getCooldown() {
        return this.cooldownCounter;
    }
}

