/*
 * Decompiled with CFR 0.152.
 */
package org.freeforums.geforce.securitycraft.network.packets;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.freeforums.geforce.securitycraft.main.HelpfulMethods;
import org.freeforums.geforce.securitycraft.main.mod_SecurityCraft;
import org.freeforums.geforce.securitycraft.misc.EnumCustomModules;
import org.freeforums.geforce.securitycraft.network.packets.PacketCUpdateCooldown;
import org.freeforums.geforce.securitycraft.network.packets.PacketHelper;
import org.freeforums.geforce.securitycraft.tileentity.TileEntityOwnable;

public class PacketCheckRetinalScanner
implements IMessage {
    private String playerName;

    public PacketCheckRetinalScanner() {
    }

    public PacketCheckRetinalScanner(String playerName) {
        this.playerName = playerName;
    }

    public void fromBytes(ByteBuf par1ByteBuf) {
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)par1ByteBuf);
    }

    public void toBytes(ByteBuf par1ByteBuf) {
        ByteBufUtils.writeUTF8String((ByteBuf)par1ByteBuf, (String)this.playerName);
    }

    public static class Handler
    extends PacketHelper
    implements IMessageHandler<PacketCheckRetinalScanner, IMessage> {
        private int[] getBlockInFront(World par1World, EntityPlayer par2EntityPlayer, double reach) {
            int[] blockInfo = new int[]{0, 0, 0, 0, -1, 0};
            MovingObjectPosition movingobjectposition = this.getMovingObjectPositionFromPlayer(par1World, par2EntityPlayer, true, reach);
            if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                blockInfo[1] = movingobjectposition.field_72311_b;
                blockInfo[2] = movingobjectposition.field_72312_c;
                blockInfo[3] = movingobjectposition.field_72309_d;
                blockInfo[4] = movingobjectposition.field_72310_e;
                blockInfo[5] = par1World.func_72805_g(blockInfo[1], blockInfo[2], blockInfo[3]);
                blockInfo[0] = Block.func_149682_b((Block)par1World.func_147439_a(blockInfo[1], blockInfo[2], blockInfo[3]));
            }
            return blockInfo;
        }

        private MovingObjectPosition getMovingObjectPositionFromPlayer(World par1World, EntityPlayer par2EntityPlayer, boolean flag, double reach) {
            float f = 1.0f;
            float playerPitch = par2EntityPlayer.field_70127_C + (par2EntityPlayer.field_70125_A - par2EntityPlayer.field_70127_C) * f;
            float playerYaw = par2EntityPlayer.field_70126_B + (par2EntityPlayer.field_70177_z - par2EntityPlayer.field_70126_B) * f;
            double playerPosX = par2EntityPlayer.field_70169_q + (par2EntityPlayer.field_70165_t - par2EntityPlayer.field_70169_q) * (double)f;
            double playerPosY = par2EntityPlayer.field_70167_r + (par2EntityPlayer.field_70163_u - par2EntityPlayer.field_70167_r) * (double)f + 1.62 - (double)par2EntityPlayer.field_70129_M;
            double playerPosZ = par2EntityPlayer.field_70166_s + (par2EntityPlayer.field_70161_v - par2EntityPlayer.field_70166_s) * (double)f;
            Vec3 vecPlayer = Vec3.func_72443_a((double)playerPosX, (double)playerPosY, (double)playerPosZ);
            float cosYaw = MathHelper.func_76134_b((float)(-playerYaw * 0.01745329f - 3.141593f));
            float sinYaw = MathHelper.func_76126_a((float)(-playerYaw * 0.01745329f - 3.141593f));
            float cosPitch = -MathHelper.func_76134_b((float)(-playerPitch * 0.01745329f));
            float sinPitch = -MathHelper.func_76126_a((float)(-playerPitch * 0.01745329f));
            float pointX = sinYaw * cosPitch;
            float pointY = sinPitch;
            float pointZ = cosYaw * cosPitch;
            Vec3 vecPoint = vecPlayer.func_72441_c((double)pointX * reach, (double)pointY * reach, (double)pointZ * reach);
            MovingObjectPosition movingobjectposition = par1World.func_72901_a(vecPlayer, vecPoint, flag);
            return movingobjectposition;
        }

        public IMessage onMessage(PacketCheckRetinalScanner packet, MessageContext context) {
            String playerName = packet.playerName;
            EntityPlayerMP par1EntityPlayer = context.getServerHandler().field_147369_b;
            int[] posXYZ = this.getBlockInFront(this.getWorld((EntityPlayer)par1EntityPlayer), (EntityPlayer)par1EntityPlayer, 1.0);
            if (this.getWorld((EntityPlayer)par1EntityPlayer).func_147439_a(posXYZ[1], posXYZ[2], posXYZ[3]) != mod_SecurityCraft.retinalScanner || this.getWorld((EntityPlayer)par1EntityPlayer).func_147438_o(posXYZ[1], posXYZ[2], posXYZ[3]) == null || !(this.getWorld((EntityPlayer)par1EntityPlayer).func_147438_o(posXYZ[1], posXYZ[2], posXYZ[3]) instanceof TileEntityOwnable) || ((TileEntityOwnable)this.getWorld((EntityPlayer)par1EntityPlayer).func_147438_o(posXYZ[1], posXYZ[2], posXYZ[3])).getOwnerUUID() == null) {
                return null;
            }
            if (posXYZ[5] > 1 && posXYZ[5] < 6 && (((TileEntityOwnable)this.getWorld((EntityPlayer)par1EntityPlayer).func_147438_o(posXYZ[1], posXYZ[2], posXYZ[3])).getOwnerUUID().matches(par1EntityPlayer.func_146103_bH().getId().toString()) || HelpfulMethods.checkForModule(this.getWorld((EntityPlayer)par1EntityPlayer), posXYZ[1], posXYZ[2], posXYZ[3], (EntityPlayer)par1EntityPlayer, EnumCustomModules.WHITELIST))) {
                this.getWorld((EntityPlayer)par1EntityPlayer).func_72921_c(posXYZ[1], posXYZ[2], posXYZ[3], posXYZ[5] + 5, 3);
                this.getWorld((EntityPlayer)par1EntityPlayer).func_147464_a(posXYZ[1], posXYZ[2], posXYZ[3], this.getWorld((EntityPlayer)par1EntityPlayer).func_147439_a(posXYZ[1], posXYZ[2], posXYZ[3]), 60);
                if (mod_SecurityCraft.eventHandler.getCooldown() <= 0) {
                    ChatComponentTranslation chatcomponenttranslation = new ChatComponentTranslation("Hello " + par1EntityPlayer.func_70005_c_() + ".", new Object[0]);
                    par1EntityPlayer.func_146105_b((IChatComponent)chatcomponenttranslation);
                    mod_SecurityCraft.network.sendTo((IMessage)new PacketCUpdateCooldown(250), par1EntityPlayer);
                    mod_SecurityCraft.eventHandler.setCooldown(250);
                }
            } else if (posXYZ[5] > 1 && posXYZ[5] < 6 && !((TileEntityOwnable)this.getWorld((EntityPlayer)par1EntityPlayer).func_147438_o(posXYZ[1], posXYZ[2], posXYZ[3])).getOwnerUUID().matches(par1EntityPlayer.func_146103_bH().getId().toString()) && mod_SecurityCraft.eventHandler.getCooldown() <= 0) {
                ChatComponentTranslation chatcomponenttranslation = new ChatComponentTranslation("[" + par1EntityPlayer.func_70005_c_() + "] Unknown player, denying access...", new Object[0]);
                par1EntityPlayer.func_146105_b((IChatComponent)chatcomponenttranslation);
                mod_SecurityCraft.network.sendTo((IMessage)new PacketCUpdateCooldown(250), par1EntityPlayer);
            }
            return null;
        }
    }
}

