/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.client.keybind;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import us.ichun.mods.ichunutil.client.keybind.KeyEvent;

public class KeyBind {
    public int keyIndex;
    public boolean holdShift;
    public boolean holdCtrl;
    public boolean holdAlt;
    public boolean canPulse;
    public int pulseTime;
    public int pulseTimer;
    public boolean ignoreHold;
    private boolean pressed;
    private boolean isMinecraftBind;
    public int usages;

    public KeyBind(int index, boolean shift, boolean ctrl, boolean alt, boolean ignoreHolding) {
        this.keyIndex = index;
        this.holdShift = shift;
        this.holdCtrl = ctrl;
        this.holdAlt = alt;
        this.ignoreHold = ignoreHolding;
    }

    public void tick() {
        if (this.canPulse) {
            if (this.pressed) {
                --this.pulseTimer;
                if (this.pulseTimer == 0) {
                    this.triggerEvent(true);
                    this.pulseTimer = this.pulseTime;
                }
            } else {
                this.pulseTimer = this.pulseTime;
            }
        }
        boolean flag = this.pressed;
        this.pressed = this.checkPressed();
        if (this.pressed != flag) {
            this.triggerEvent(false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean checkPressed() {
        boolean stateAlt;
        boolean stateShift;
        boolean bl = stateShift = this.holdShift && GuiScreen.func_146272_n() || !this.holdShift && (this.ignoreHold || !GuiScreen.func_146272_n() || this.keyIndex == 42 || this.keyIndex == 54);
        boolean stateCtrl = this.holdCtrl && GuiScreen.func_146271_m() || !this.holdCtrl && (this.ignoreHold || !GuiScreen.func_146271_m() || this.keyIndex == (Minecraft.field_142025_a ? 219 : 29) || this.keyIndex == (Minecraft.field_142025_a ? 220 : 157));
        boolean bl2 = stateAlt = this.holdAlt && (Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184)) || !this.holdAlt && (this.ignoreHold || !Keyboard.isKeyDown((int)56) && !Keyboard.isKeyDown((int)184) || this.keyIndex == 56 || this.keyIndex == 184);
        if (!(stateShift && stateCtrl && stateAlt)) {
            return false;
        }
        return KeyBind.isPressed(this.keyIndex);
    }

    public KeyBind setPulse(boolean flag, int time) {
        if (flag) {
            this.canPulse = true;
            this.pulseTimer = this.pulseTime = time;
        } else {
            this.canPulse = false;
        }
        return this;
    }

    public void triggerEvent(boolean pulse) {
        MinecraftForge.EVENT_BUS.post((Event)new KeyEvent(this, pulse));
    }

    public KeyBind setIsMinecraftBind() {
        this.isMinecraftBind = true;
        return this;
    }

    public boolean isMinecraftBind() {
        return this.isMinecraftBind;
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeyBind) {
            KeyBind bind = (KeyBind)obj;
            return bind.keyIndex == this.keyIndex && bind.holdShift == this.holdShift && bind.holdCtrl == this.holdCtrl && bind.holdAlt == this.holdAlt && bind.canPulse == this.canPulse && bind.pulseTime == this.pulseTime && bind.ignoreHold == this.ignoreHold;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isPressed(int key) {
        if (key < 0) {
            return Mouse.isButtonDown((int)(key + 100));
        }
        return Keyboard.isKeyDown((int)key);
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.keyIndex);
        if (this.holdShift) {
            sb.append(":SHIFT");
        }
        if (this.holdCtrl) {
            sb.append(":CTRL");
        }
        if (this.holdAlt) {
            sb.append(":ALT");
        }
        return sb.toString();
    }

    public void deserialize(String s) {
        String[] strings = s.split(":");
        try {
            this.keyIndex = Integer.parseInt(strings[0].trim());
            this.holdShift = s.contains("SHIFT");
            this.holdCtrl = s.contains("CTRL");
            this.holdAlt = s.contains("ALT");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

