/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.client.model;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.Entity;
import us.ichun.mods.ichunutil.common.core.util.ObfHelper;
import us.ichun.mods.ichunutil.common.module.tabula.common.project.components.CubeInfo;

public class ModelHelper {
    public static Random rand = new Random();
    public static HashMap<Class<? extends Render>, ArrayList<ModelRenderer>> classToModelRendererMap = new HashMap();

    public static ArrayList<ModelRenderer> separateChildren(ArrayList<ModelRenderer> modelList) {
        for (int i = 0; i < modelList.size(); ++i) {
            ModelRenderer renderer = modelList.get(i);
            if (renderer.field_78805_m == null) continue;
            ArrayList<ModelRenderer> children = new ArrayList<ModelRenderer>();
            while (!renderer.field_78805_m.isEmpty()) {
                children.add((ModelRenderer)renderer.field_78805_m.get(renderer.field_78805_m.size() - 1));
                renderer.field_78805_m.remove(renderer.field_78805_m.size() - 1);
            }
            ModelHelper.separateChildren(children);
            modelList.addAll(children);
        }
        return modelList;
    }

    public static ArrayList<ModelRenderer> getModelCubesCopy(ArrayList<ModelRenderer> modelList, ModelBase base, Entity ent) {
        if (RenderManager.field_78727_a.field_78724_e != null && RenderManager.field_78727_a.field_78734_h != null && ent != null) {
            for (int i = 0; i < modelList.size(); ++i) {
                ModelRenderer cube = modelList.get(i);
                if (!cube.field_78812_q) continue;
                GLAllocation.func_74523_b((int)cube.field_78811_r);
                cube.field_78812_q = false;
            }
            RenderManager.field_78727_a.func_78713_a(ent).func_76986_a(ent, 0.0, -500.0, 0.0, 0.0f, 1.0f);
            ArrayList<ModelRenderer> modelListCopy = new ArrayList<ModelRenderer>(modelList);
            ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
            for (int i = modelListCopy.size() - 1; i >= 0; --i) {
                ModelRenderer cube = modelListCopy.get(i);
                try {
                    if (cube.field_78812_q) continue;
                    modelListCopy.remove(i);
                    continue;
                }
                catch (Exception e) {
                    ObfHelper.obfWarning();
                    e.printStackTrace();
                }
            }
            for (ModelRenderer cube : modelListCopy) {
                list.add(ModelHelper.buildCopy(cube, base, 0, true));
            }
            return list;
        }
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        for (int i = 0; i < modelList.size(); ++i) {
            ModelRenderer cube = modelList.get(i);
            list.add(ModelHelper.buildCopy(cube, base, 0, true));
        }
        return list;
    }

    public static CubeInfo createCubeInfoFromModelBox(ModelRenderer rend, ModelBox box, String name) {
        TextureOffset textureoffset;
        CubeInfo info = new CubeInfo(name);
        info.dimensions[0] = (int)Math.abs(box.field_78248_d - box.field_78252_a);
        info.dimensions[1] = (int)Math.abs(box.field_78249_e - box.field_78250_b);
        info.dimensions[2] = (int)Math.abs(box.field_78246_f - box.field_78251_c);
        info.position[0] = rend.field_78800_c;
        info.position[1] = rend.field_78797_d;
        info.position[2] = rend.field_78798_e;
        info.offset[0] = box.field_78252_a;
        info.offset[1] = box.field_78250_b;
        info.offset[2] = box.field_78251_c;
        info.rotation[0] = Math.toDegrees(rend.field_78795_f);
        info.rotation[1] = Math.toDegrees(rend.field_78796_g);
        info.rotation[2] = Math.toDegrees(rend.field_78808_h);
        info.scale[2] = 1.0;
        info.scale[1] = 1.0;
        info.scale[0] = 1.0;
        PositionTextureVertex[] vertices = box.field_78254_i[1].field_78239_a;
        info.txMirror = (vertices[info.txMirror ? 1 : 2].field_78243_a.field_72448_b - vertices[info.txMirror ? 3 : 0].field_78243_a.field_72448_b - (double)info.dimensions[1]) / 2.0 < 0.0;
        info.txOffset[0] = (int)(vertices[info.txMirror ? 2 : 1].field_78241_b * rend.field_78801_a);
        info.txOffset[1] = (int)(vertices[info.txMirror ? 2 : 1].field_78242_c * rend.field_78799_b) - info.dimensions[2];
        float f = vertices[info.txMirror ? 2 : 1].field_78242_c;
        int n = info.txMirror ? 1 : 2;
        if (f > vertices[n].field_78242_c) {
            info.txMirror = !info.txMirror;
            info.txOffset[0] = (int)(vertices[info.txMirror ? 2 : 1].field_78241_b * rend.field_78801_a);
            info.txOffset[1] = (int)(vertices[info.txMirror ? 2 : 1].field_78242_c * rend.field_78799_b) - info.dimensions[2];
        }
        if (box.field_78247_g != null && (textureoffset = rend.field_78810_s.func_78084_a(box.field_78247_g)) != null) {
            info.txOffset[0] = textureoffset.field_78783_a;
            info.txOffset[1] = textureoffset.field_78782_b;
        }
        info.mcScale = (vertices[info.txMirror ? 1 : 2].field_78243_a.field_72448_b - vertices[info.txMirror ? 3 : 0].field_78243_a.field_72448_b - (double)info.dimensions[1]) / 2.0;
        return info;
    }

    public static ModelRenderer buildCopy(ModelRenderer original, ModelBase copyBase, int depth, boolean hasFullModelBox) {
        int txOffsetX = original.field_78803_o;
        int txOffsetY = original.field_78813_p;
        ModelRenderer cubeCopy = new ModelRenderer(copyBase, txOffsetX, txOffsetY);
        cubeCopy.field_78799_b = original.field_78799_b;
        cubeCopy.field_78801_a = original.field_78801_a;
        for (int j = 0; j < original.field_78804_l.size(); ++j) {
            ModelBox box = (ModelBox)original.field_78804_l.get(j);
            CubeInfo info = ModelHelper.createCubeInfoFromModelBox(original, box, box.field_78247_g != null ? box.field_78247_g.substring(box.field_78247_g.lastIndexOf(".") + 1) : "");
            cubeCopy.field_78809_i = info.txMirror;
            cubeCopy.field_78803_o = info.txOffset[0];
            cubeCopy.field_78813_p = info.txOffset[1];
            if (hasFullModelBox) {
                cubeCopy.func_78790_a((float)info.offset[0], (float)info.offset[1], (float)info.offset[2], info.dimensions[0], info.dimensions[1], info.dimensions[2], (float)info.mcScale);
                continue;
            }
            ModelBox randBox = (ModelBox)original.field_78804_l.get(rand.nextInt(original.field_78804_l.size()));
            float x = randBox.field_78252_a + (randBox.field_78248_d - randBox.field_78252_a > 0.0f ? (float)rand.nextInt((int)(randBox.field_78248_d - randBox.field_78252_a) > 0 ? (int)(randBox.field_78248_d - randBox.field_78252_a) : 1) : 0.0f);
            float y = randBox.field_78250_b + (randBox.field_78249_e - randBox.field_78250_b > 0.0f ? (float)rand.nextInt((int)(randBox.field_78249_e - randBox.field_78250_b) > 0 ? (int)(randBox.field_78249_e - randBox.field_78250_b) : 1) : 0.0f);
            float z = randBox.field_78251_c + (randBox.field_78246_f - randBox.field_78251_c > 0.0f ? (float)rand.nextInt((int)(randBox.field_78246_f - randBox.field_78251_c) > 0 ? (int)(randBox.field_78246_f - randBox.field_78251_c) : 1) : 0.0f);
            cubeCopy.func_78790_a(x, y, z, info.dimensions[0], info.dimensions[1], info.dimensions[2], (float)info.mcScale);
        }
        cubeCopy.field_78809_i = original.field_78809_i;
        if (original.field_78805_m != null && depth < 20) {
            for (int i = 0; i < original.field_78805_m.size(); ++i) {
                ModelRenderer child = (ModelRenderer)original.field_78805_m.get(i);
                cubeCopy.func_78792_a(ModelHelper.buildCopy(child, copyBase, depth + 1, hasFullModelBox));
            }
        }
        cubeCopy.func_78793_a(original.field_78800_c, original.field_78797_d, original.field_78798_e);
        cubeCopy.field_78795_f = original.field_78795_f;
        cubeCopy.field_78796_g = original.field_78796_g;
        cubeCopy.field_78808_h = original.field_78808_h;
        return cubeCopy;
    }

    public static ArrayList<ModelRenderer> getModelCubes(ModelBase parent) {
        return new ArrayList<ModelRenderer>(ModelHelper.getModelCubesWithNames(parent).values());
    }

    public static HashMap<String, ModelRenderer> getModelCubesWithNames(ModelBase parent) {
        HashMap<String, ModelRenderer> list = new HashMap<String, ModelRenderer>();
        HashMap<String, ModelRenderer> list1 = new HashMap<String, ModelRenderer>();
        if (parent != null) {
            for (Class clz = parent.getClass(); clz != ModelBase.class && ModelBase.class.isAssignableFrom(clz); clz = clz.getSuperclass()) {
                try {
                    Field[] fieldArray;
                    for (Field f : fieldArray = clz.getDeclaredFields()) {
                        ModelRenderer rend;
                        f.setAccessible(true);
                        if (f.getType() == ModelRenderer.class) {
                            if ((clz != ModelBiped.class || f.getName().equalsIgnoreCase("bipedCloak") || f.getName().equalsIgnoreCase("k") || f.getName().equalsIgnoreCase("field_78122_k")) && clz == ModelBiped.class || (rend = (ModelRenderer)f.get(parent)) == null) continue;
                            String name = f.getName();
                            if (rend.field_78802_n != null) {
                                name = rend.field_78802_n;
                                while (list.containsKey(name)) {
                                    name = name + "_";
                                }
                            }
                            list.put(name, rend);
                            continue;
                        }
                        if (f.getType() != ModelRenderer[].class || (rend = (ModelRenderer)f.get(parent)) == null) continue;
                        list1.put(f.getName(), rend);
                    }
                    continue;
                }
                catch (Exception exception) {
                    throw new ReflectionHelper.UnableToAccessFieldException(new String[0], exception);
                }
            }
        }
        for (Map.Entry entry : list1.entrySet()) {
            int count = 1;
            for (ModelRenderer cube : (ModelRenderer[])entry.getValue()) {
                if (cube == null || list.containsValue(cube)) continue;
                list.put((String)entry.getKey() + count, cube);
                ++count;
            }
        }
        ArrayList<ModelRenderer> children = new ArrayList<ModelRenderer>();
        for (Map.Entry e : list.entrySet()) {
            ModelRenderer cube = (ModelRenderer)e.getValue();
            for (ModelRenderer child : ModelHelper.getChildren(cube, true, 0)) {
                if (children.contains(child)) continue;
                children.add(child);
            }
        }
        for (ModelRenderer child : children) {
            Iterator<Map.Entry<String, ModelRenderer>> ite = list.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, ModelRenderer> e = ite.next();
                if (e.getValue() != child) continue;
                ite.remove();
            }
        }
        return list;
    }

    public static ArrayList<ModelRenderer> getMultiModelCubes(ArrayList<ModelBase> parent) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        for (ModelBase base : parent) {
            list.addAll(ModelHelper.getModelCubes(base));
        }
        return list;
    }

    public static ArrayList<ModelRenderer> getChildren(ModelRenderer parent, boolean recursive, int depth) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        if (parent.field_78805_m != null && depth < 20) {
            for (int i = 0; i < parent.field_78805_m.size(); ++i) {
                ModelRenderer child = (ModelRenderer)parent.field_78805_m.get(i);
                if (recursive) {
                    ArrayList<ModelRenderer> children = ModelHelper.getChildren(child, recursive, depth + 1);
                    for (ModelRenderer child1 : children) {
                        if (list.contains(child1)) continue;
                        list.add(child1);
                    }
                }
                if (list.contains(child)) continue;
                list.add(child);
            }
        }
        return list;
    }

    public static ModelBase getPossibleModel(Render rend) {
        ArrayList models = new ArrayList();
        if (rend != null) {
            try {
                for (Class<?> clz = rend.getClass(); clz != Render.class; clz = clz.getSuperclass()) {
                    Field[] fields;
                    ArrayList<ModelBase> priorityLevel = new ArrayList<ModelBase>();
                    for (Field f : fields = clz.getDeclaredFields()) {
                        ModelBase[] modelBases;
                        f.setAccessible(true);
                        if (ModelBase.class.isAssignableFrom(f.getType())) {
                            ModelBase base = (ModelBase)f.get(rend);
                            if (base == null) continue;
                            priorityLevel.add(base);
                            continue;
                        }
                        if (!ModelBase[].class.isAssignableFrom(f.getType()) || (modelBases = (ModelBase[])f.get(rend)) == null) continue;
                        priorityLevel.addAll(Arrays.asList(modelBases));
                    }
                    models.add(priorityLevel);
                    if (clz != RendererLivingEntity.class) continue;
                    ArrayList<ModelBase> topPriority = new ArrayList<ModelBase>();
                    for (Field f : fields) {
                        ModelBase base;
                        f.setAccessible(true);
                        if (!ModelBase.class.isAssignableFrom(f.getType()) || !f.getName().equalsIgnoreCase(ObfHelper.mainModel[0]) && !f.getName().equalsIgnoreCase(ObfHelper.mainModel[1]) || (base = (ModelBase)f.get(rend)) == null) continue;
                        topPriority.add(base);
                    }
                    models.add(topPriority);
                }
            }
            catch (Exception e) {
                throw new ReflectionHelper.UnableToAccessFieldException(new String[0], e);
            }
        }
        ModelBase base1 = null;
        int priorityLevel = -1;
        int size = -1;
        int currentPriority = 0;
        for (ArrayList arrayList : models) {
            for (ModelBase base : arrayList) {
                ArrayList<ModelRenderer> mrs = ModelHelper.getModelCubes(base);
                if (mrs.size() <= size && (mrs.size() != size || currentPriority <= priorityLevel)) continue;
                size = mrs.size();
                base1 = base;
                priorityLevel = currentPriority;
            }
            ++currentPriority;
        }
        return base1;
    }

    public static boolean areModelsEqual(ModelBase model1, ModelBase model2) {
        if (model1.getClass() == model2.getClass() && model1.field_78089_u == model2.field_78089_u && model1.field_78090_t == model2.field_78090_t) {
            ArrayList<ModelRenderer> parts1 = ModelHelper.getModelCubes(model1);
            ArrayList<ModelRenderer> parts2 = ModelHelper.getModelCubes(model2);
            if (parts1.size() == parts2.size()) {
                for (int i = parts1.size() - 1; i >= 0; --i) {
                    ModelRenderer rend1 = parts1.get(i);
                    boolean remove = true;
                    for (int k = rend1.field_78804_l.size() - 1; k >= 0; --k) {
                        ModelBox box1 = (ModelBox)rend1.field_78804_l.get(k);
                        CubeInfo cube1 = ModelHelper.createCubeInfoFromModelBox(rend1, box1, box1.field_78247_g != null ? box1.field_78247_g : "");
                        boolean found = false;
                        for (int j = parts2.size() - 1; j >= 0; --j) {
                            ModelRenderer rend2 = parts2.get(j);
                            if (rend1.field_78804_l.size() == rend2.field_78804_l.size() && (rend1.field_78805_m == null && rend2.field_78805_m == null || rend1.field_78805_m != null && rend2.field_78805_m != null && rend1.field_78805_m.size() == rend2.field_78805_m.size())) {
                                for (int l = rend2.field_78804_l.size(); l >= 0; --l) {
                                    ModelBox box2 = (ModelBox)rend2.field_78804_l.get(l);
                                    CubeInfo cube2 = ModelHelper.createCubeInfoFromModelBox(rend2, box2, box2.field_78247_g != null ? box2.field_78247_g : "");
                                    for (int m = 0; m < 3 && cube1.dimensions[m] == cube2.dimensions[m] && cube1.offset[m] == cube2.offset[m]; ++m) {
                                        if (m != 2) continue;
                                        found = true;
                                    }
                                    if (found) break;
                                }
                            }
                            if (found) break;
                        }
                        if (found) continue;
                        remove = false;
                    }
                    if (!remove) continue;
                    parts1.remove(i);
                }
                return parts1.isEmpty();
            }
        }
        return false;
    }

    public static ArrayList<ModelRenderer> getModelCubes(Entity entity) {
        Render rend = RenderManager.field_78727_a.func_78713_a(entity);
        ArrayList<ModelRenderer> map = classToModelRendererMap.get(rend.getClass());
        if (map == null) {
            map = ModelHelper.getModelCubes(ModelHelper.getPossibleModel(rend));
            classToModelRendererMap.put(rend.getClass(), map);
        }
        return map;
    }
}

