/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.tracker;

import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import us.ichun.mods.ichunutil.common.iChunUtil;
import us.ichun.mods.ichunutil.common.tracker.EntityInfo;
import us.ichun.mods.ichunutil.common.tracker.IAdditionalTrackerInfo;

public class TrackerRegistry {
    public final EnumTrackerType type;
    public EntityLivingBase entityToTrack;
    public int length;
    public ArrayList<Class<? extends IAdditionalTrackerInfo>> additionalInfo;
    public ArrayList<EntityInfo> trackedInfo;

    public TrackerRegistry(EnumTrackerType theType, EntityLivingBase tracker, int totalLength) {
        this.type = theType;
        this.entityToTrack = tracker;
        this.length = totalLength;
        this.additionalInfo = new ArrayList();
        this.trackedInfo = new ArrayList();
    }

    public TrackerRegistry addTracker(Class<? extends IAdditionalTrackerInfo> tracker) {
        for (Class<? extends IAdditionalTrackerInfo> trackers : this.additionalInfo) {
            if (!tracker.equals(trackers)) continue;
            return this;
        }
        this.additionalInfo.add(tracker);
        for (EntityInfo info : this.trackedInfo) {
            try {
                info.addTracker(tracker.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                iChunUtil.console("Error creating tracker: " + tracker.getName(), true);
                e.printStackTrace();
            }
        }
        return this;
    }

    public boolean update() {
        if (this.type.equals((Object)EnumTrackerType.SPECIFIC) && this.entityToTrack.field_70128_L) {
            return false;
        }
        EntityInfo info = new EntityInfo(this.entityToTrack);
        for (Class<? extends IAdditionalTrackerInfo> tracker : this.additionalInfo) {
            try {
                info.addTracker(tracker.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                iChunUtil.console("Error creating trackers: " + tracker.getName(), true);
                e.printStackTrace();
            }
        }
        info.update();
        this.trackedInfo.add(0, info);
        while (this.trackedInfo.size() > this.length) {
            this.trackedInfo.remove(this.trackedInfo.size() - 1);
        }
        return true;
    }

    public static enum EnumTrackerType {
        SPECIFIC,
        PERSISTENT_PLAYER;

    }
}

