/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.keygrip.client.gui.window;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import us.ichun.mods.ichunutil.client.gui.window.IWorkspace;
import us.ichun.mods.ichunutil.client.gui.window.Window;
import us.ichun.mods.ichunutil.client.gui.window.WindowPopup;
import us.ichun.mods.ichunutil.client.gui.window.element.Element;
import us.ichun.mods.ichunutil.client.gui.window.element.ElementButton;
import us.ichun.mods.ichunutil.client.gui.window.element.ElementListTree;
import us.ichun.mods.keygrip.client.core.ResourceHelper;
import us.ichun.mods.keygrip.client.gui.GuiWorkspace;
import us.ichun.mods.keygrip.common.scene.Scene;

public class WindowOpenScene
extends Window {
    public ElementListTree modelList;

    public WindowOpenScene(IWorkspace parent, int x, int y, int w, int h, int minW, int minH) {
        super(parent, x, y, w, h, minW, minH, "window.open.title", true);
        this.elements.add(new ElementButton(this, this.width - 140, this.height - 22, 60, 16, 1, false, 1, 1, "element.button.ok"));
        this.elements.add(new ElementButton(this, this.width - 70, this.height - 22, 60, 16, 0, false, 1, 1, "element.button.cancel"));
        this.modelList = new ElementListTree(this, 4, 14, this.width - 8, this.height - 3 - 22 - 16, 3, false, false);
        this.elements.add(this.modelList);
        ArrayList<File> files = new ArrayList<File>();
        File[] textures = ResourceHelper.getScenesDir().listFiles();
        for (File file : textures) {
            if (file.isDirectory() || !FilenameUtils.getExtension((String)file.getName()).equals("kgs")) continue;
            files.add(file);
        }
        for (File file : files) {
            this.modelList.createTree(null, file, 26, 0, false, false);
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        super.draw(mouseX, mouseY);
    }

    @Override
    public void elementTriggered(Element element) {
        if (element.id == 0) {
            this.workspace.removeWindow(this, true);
        }
        if (element.id == 1 || element.id == 3) {
            for (int i = 0; i < this.modelList.trees.size(); ++i) {
                Scene scene;
                ElementListTree.Tree tree = this.modelList.trees.get(i);
                if (!tree.selected) continue;
                if (this.workspace.windowDragged == this) {
                    this.workspace.windowDragged = null;
                }
                if ((scene = Scene.openScene((File)tree.attachedObject)) == null) {
                    this.workspace.addWindowOnTop(new WindowPopup(this.workspace, 0, 0, 180, 80, 180, 80, "window.open.failed").putInMiddleOfScreen());
                    break;
                }
                ((GuiWorkspace)this.workspace).sceneManager.addScene(scene);
                this.workspace.removeWindow(this, true);
                break;
            }
        }
    }
}

