/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.keygrip.common.packet;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import us.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import us.ichun.mods.keygrip.client.gui.GuiWorkspace;
import us.ichun.mods.keygrip.common.Keygrip;

public class PacketSceneStatus
extends AbstractPacket {
    public int startPoint;
    public String sceneName;
    public boolean playing;

    public PacketSceneStatus() {
    }

    public PacketSceneStatus(int start, String name, boolean play) {
        this.startPoint = start;
        this.sceneName = name;
        this.playing = play;
    }

    @Override
    public void writeTo(ByteBuf buffer, Side side) {
        buffer.writeInt(this.startPoint);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.sceneName);
        buffer.writeBoolean(this.playing);
    }

    @Override
    public void readFrom(ByteBuf buffer, Side side) {
        this.startPoint = buffer.readInt();
        this.sceneName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.playing = buffer.readBoolean();
    }

    @Override
    public void execute(Side side, EntityPlayer player) {
        this.handleClient();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        GuiWorkspace workspace = Keygrip.proxy.tickHandlerClient.workspace;
        if (workspace.hasOpenScene() && workspace.getOpenScene().identifier.equals(this.sceneName)) {
            workspace.getOpenScene().playing = this.playing;
            workspace.timeline.timeline.setCurrentPos(this.startPoint);
            workspace.timeline.timeline.focusOnTicker();
            if (this.playing && Keygrip.proxy.tickHandlerClient.sceneFrom != null && this.sceneName.equals(Keygrip.proxy.tickHandlerClient.sceneFrom.identifier) && Keygrip.config.playbackSceneWhileRecording == 1 && Keygrip.proxy.tickHandlerClient.actionToRecord != null) {
                Keygrip.proxy.tickHandlerClient.startRecord = true;
            }
        }
    }
}

