/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.keygrip.common.scene;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S18PacketEntityTeleport;
import net.minecraft.world.WorldServer;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import us.ichun.mods.ichunutil.client.gui.window.WindowPopup;
import us.ichun.mods.ichunutil.common.core.util.IOUtil;
import us.ichun.mods.keygrip.client.core.ResourceHelper;
import us.ichun.mods.keygrip.client.gui.GuiWorkspace;
import us.ichun.mods.keygrip.common.Keygrip;
import us.ichun.mods.keygrip.common.packet.PacketSceneFragment;
import us.ichun.mods.keygrip.common.scene.action.Action;
import us.ichun.mods.keygrip.common.scene.action.LimbComponent;

public class Scene {
    public static final transient int VERSION = 1;
    public static final transient int PRECISION = 1000;
    @SerializedName(value="n")
    public String name;
    @SerializedName(value="i")
    public String identifier;
    @SerializedName(value="v")
    public int version = 1;
    @SerializedName(value="a")
    public ArrayList<Action> actions = new ArrayList();
    @SerializedName(value="s")
    public int[] startPos = new int[3];
    public transient File saveFile;
    public transient String saveFileMd5;
    public transient int playTime;
    public transient boolean playing;
    public transient WorldServer server;

    public Scene(String name) {
        this.name = name;
        this.identifier = RandomStringUtils.randomAscii((int)20);
    }

    public void update() {
        if (this.playing) {
            if (this.server != null) {
                for (Action a : this.actions) {
                    if (a.getLength() <= 0) continue;
                    if (this.playTime > a.startKey + a.getLength() || this.playTime < a.startKey || a.hidden == 1) {
                        if (this.playTime != 5 || a.precreateEntity != 1 || a.state == null || a.state.ent == null) continue;
                        FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148537_a((Packet)new S18PacketEntityTeleport((Entity)a.state.ent), a.state.ent.field_70170_p.field_73011_w.field_76574_g);
                        continue;
                    }
                    if (this.playTime == a.startKey) {
                        if (a.precreateEntity != 1 && a.createState(this.server, (double)(this.startPos[0] + a.offsetPos[0]) / 1000.0, (double)(this.startPos[1] + a.offsetPos[1]) / 1000.0, (double)(this.startPos[2] + a.offsetPos[2]) / 1000.0)) {
                            if (a.state.ent == null) {
                                Keygrip.console("Error initializing action: " + a.name, true);
                            } else {
                                a.state.ent.func_70012_b((double)(this.startPos[0] + a.offsetPos[0]) / 1000.0, (double)(this.startPos[1] + a.offsetPos[1]) / 1000.0, (double)(this.startPos[2] + a.offsetPos[2]) / 1000.0, (float)a.rotation[0] / 1000.0f, (float)a.rotation[1] / 1000.0f);
                                this.server.func_72838_d((Entity)a.state.ent);
                                if (a.state.ent instanceof EntityPlayer) {
                                    this.server.field_73010_i.remove(a.state.ent);
                                    this.server.func_72854_c();
                                }
                            }
                        }
                    } else if (this.playTime == a.startKey + a.getLength() && a.persistEntity != 1 && a.state != null && a.state.ent != null) {
                        a.state.ent.func_70106_y();
                        for (Entity ent : a.state.additionalEnts) {
                            ent.func_70106_y();
                        }
                        a.state = null;
                    }
                    a.doAction(this, this.playTime);
                    if (this.playTime - a.startKey != 5 || a.state == null || a.state.ent == null || a.precreateEntity == 1) continue;
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148537_a((Packet)new S18PacketEntityTeleport((Entity)a.state.ent), a.state.ent.field_70170_p.field_73011_w.field_76574_g);
                }
            }
            ++this.playTime;
        }
    }

    public int getLength() {
        int l = 0;
        for (Action a : this.actions) {
            if (a.startKey + a.getLength() <= l) continue;
            l = a.startKey + a.getLength();
        }
        return l;
    }

    public void create(WorldServer world) {
        this.server = world;
        for (Action a : this.actions) {
            if (this.playTime > a.startKey + a.getLength() && a.persistEntity != 1 || a.hidden == 1 || (this.playTime >= a.startKey || a.precreateEntity != 1) && this.playTime < a.startKey || !a.createState(world, (double)(this.startPos[0] + a.offsetPos[0]) / 1000.0, (double)(this.startPos[1] + a.offsetPos[1]) / 1000.0, (double)(this.startPos[2] + a.offsetPos[2]) / 1000.0)) continue;
            if (a.state.ent == null) {
                Keygrip.console("Error initializing action: " + a.name, true);
                continue;
            }
            a.state.ent.func_70012_b((double)(this.startPos[0] + a.offsetPos[0]) / 1000.0, (double)(this.startPos[1] + a.offsetPos[1]) / 1000.0, (double)(this.startPos[2] + a.offsetPos[2]) / 1000.0, (float)a.rotation[0] / 1000.0f, (float)a.rotation[1] / 1000.0f);
            world.func_72838_d((Entity)a.state.ent);
            if (a.state.ent instanceof EntityPlayer) {
                world.field_73010_i.remove(a.state.ent);
                world.func_72854_c();
            }
            LimbComponent lastLook = null;
            LimbComponent lastPos = null;
            int lastLookInt = -1;
            for (Map.Entry<Integer, LimbComponent> e : a.lookComponents.entrySet()) {
                if (e.getKey() <= lastLookInt || e.getKey() >= this.playTime) continue;
                lastLookInt = e.getKey();
                lastLook = e.getValue();
            }
            int lastPosInt = -1;
            for (Map.Entry<Integer, LimbComponent> e : a.posComponents.entrySet()) {
                if (e.getKey() <= lastPosInt || e.getKey() >= this.playTime) continue;
                lastPosInt = e.getKey();
                lastPos = e.getValue();
            }
            if (lastLook != null) {
                a.state.ent.field_70759_as = a.state.ent.field_70177_z = (float)(lastLook.actionChange[0] / 1000);
                a.state.ent.field_70125_A = lastLook.actionChange[1] / 1000;
            }
            if (lastPos == null) continue;
            a.state.ent.func_70012_b((double)(lastPos.actionChange[0] + (a.offsetPos[0] + this.startPos[0])) / 1000.0, (double)(lastPos.actionChange[1] + (a.offsetPos[1] + this.startPos[1])) / 1000.0, (double)(lastPos.actionChange[2] + (a.offsetPos[2] + this.startPos[2])) / 1000.0, a.state.ent.field_70177_z, a.state.ent.field_70125_A);
        }
    }

    public void play() {
        this.playing = true;
    }

    public void stop() {
        for (Action a : this.actions) {
            if (a.state == null || a.state.ent == null) continue;
            a.state.ent.func_70106_y();
            for (Entity ent : a.state.additionalEnts) {
                ent.func_70106_y();
            }
        }
        this.playing = false;
    }

    public void destroy() {
        for (Action a : this.actions) {
            if (a.state == null || a.state.ent == null) continue;
            a.state.ent.func_70106_y();
            for (Entity ent : a.state.additionalEnts) {
                ent.func_70106_y();
            }
        }
    }

    public void repair() {
    }

    public static Scene openScene(File file) {
        try {
            byte[] data = new byte[(int)file.length()];
            FileInputStream stream = new FileInputStream(file);
            stream.read(data);
            stream.close();
            Scene scene = (Scene)new Gson().fromJson(IOUtil.decompress(data), Scene.class);
            scene.saveFile = file;
            scene.saveFileMd5 = IOUtil.getMD5Checksum(file);
            scene.repair();
            return scene;
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
            return null;
        }
    }

    public static boolean saveScene(Scene scene, File file) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            stream.write(IOUtil.compress(new Gson().toJson((Object)scene)));
            stream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void saveSceneActions(Scene scene) {
        ArrayList<String> actNames = new ArrayList<String>();
        for (Action action : scene.actions) {
            try {
                String name = action.name;
                int append = 0;
                while (actNames.contains(name)) {
                    if (append != 0) {
                        name = name.substring(0, name.length() - 2);
                    }
                    name = name + "_" + ++append;
                }
                FileOutputStream stream = new FileOutputStream(new File(ResourceHelper.getActionsDir(), scene.name + "-" + name + ".kga"));
                stream.write(IOUtil.compress(new Gson().toJson((Object)action)));
                stream.close();
                actNames.add(name);
            }
            catch (IOException iOException) {}
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendSceneToServer(Scene scene) {
        File temp = new File(ResourceHelper.getTempDir(), Integer.toString(Math.abs(scene.hashCode())) + "-send.kgs");
        if (Scene.saveScene(scene, temp)) {
            try {
                byte[] data = IOUtils.toByteArray((InputStream)new FileInputStream(temp));
                int maxFile = 31000;
                int fileSize = data.length;
                int packetsToSend = (int)Math.ceil((float)fileSize / 31000.0f);
                int packetCount = 0;
                int offset = 0;
                while (fileSize > 0) {
                    int index;
                    byte[] fileBytes = new byte[fileSize > 31000 ? 31000 : fileSize];
                    for (index = 0; index < fileBytes.length; ++index) {
                        fileBytes[index] = data[index + offset];
                    }
                    int time = 0;
                    if (Minecraft.func_71410_x().field_71462_r instanceof GuiWorkspace) {
                        GuiWorkspace workspace = (GuiWorkspace)Minecraft.func_71410_x().field_71462_r;
                        time = workspace.timeline.timeline.getCurrentPos();
                        if (time > scene.getLength()) {
                            time = 0;
                        }
                    }
                    Keygrip.channel.sendToServer(new PacketSceneFragment(time, scene.identifier, packetsToSend, packetCount, fileSize > 31000 ? 31000 : fileSize, fileBytes));
                    ++packetCount;
                    fileSize -= 31000;
                    offset += index;
                }
            }
            catch (IOException data) {
                // empty catch block
            }
            temp.delete();
        } else if (Minecraft.func_71410_x().field_71462_r instanceof GuiWorkspace) {
            GuiWorkspace workspace = (GuiWorkspace)Minecraft.func_71410_x().field_71462_r;
            workspace.addWindowOnTop(new WindowPopup(workspace, 0, 0, 180, 80, 180, 80, "window.playScene.failed").putInMiddleOfScreen());
        }
    }
}

