/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import us.ichun.mods.ichunutil.common.core.updateChecker.ModVersionChecker;
import us.ichun.mods.ichunutil.common.iChunUtil;

@SideOnly(value=Side.CLIENT)
public class GuiModUpdateNotification
extends Gui {
    private static final ResourceLocation rlAchievement = new ResourceLocation("textures/gui/achievement/achievement_background.png");
    private Minecraft mc;
    private int width;
    private int height;
    private String topText;
    private long achiTime;
    public ArrayList<String> modUpdatesPending = new ArrayList();
    public ArrayList<String> modUpdates = new ArrayList();
    public ArrayList<String> modUpdatesDone = new ArrayList();
    public boolean shouldRender;
    public boolean pending;

    public GuiModUpdateNotification(Minecraft par1Minecraft) {
        this.mc = par1Minecraft;
        this.shouldRender = false;
        this.topText = StatCollector.func_74838_a((String)"ichun.gui.newUpdate");
    }

    public void addModUpdate(String modName, String version) {
        boolean render = this.shouldRender;
        if (iChunUtil.config.versionNotificationFrequency == 3) {
            iChunUtil.console("[NEW UPDATE AVAILABLE] " + modName + " - " + version);
            return;
        }
        if (iChunUtil.config.versionNotificationFrequency == 2) {
            for (Map.Entry<String, String> e : iChunUtil.proxy.versionChecker.entrySet()) {
                String oldVer = iChunUtil.proxy.prevVerChecker.get(e.getKey());
                if (oldVer == null || !oldVer.equals(e.getValue())) continue;
                return;
            }
        } else {
            boolean bl = this.shouldRender = iChunUtil.config.versionNotificationFrequency == 0 || iChunUtil.config.versionNotificationFrequency == 1 && ModVersionChecker.differentDay;
        }
        if (!this.modUpdatesPending.contains(modName + " - " + version)) {
            this.pending = true;
            this.modUpdatesPending.add(modName + " - " + version);
            while ((this.height == 0 || (double)this.modUpdates.size() * 32.0 < (double)this.height) && !this.modUpdatesPending.isEmpty()) {
                this.modUpdates.add(this.modUpdatesPending.get(0));
                this.modUpdatesPending.remove(0);
                this.achiTime = render ? Minecraft.func_71386_F() - 250L : Minecraft.func_71386_F();
                Collections.sort(this.modUpdates);
            }
        }
    }

    private void updateWindowScale() {
        GL11.glViewport((int)0, (int)0, (int)this.mc.field_71443_c, (int)this.mc.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.width = this.mc.field_71443_c;
        this.height = this.mc.field_71440_d;
        ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        this.width = scaledresolution.func_78326_a();
        this.height = scaledresolution.func_78328_b();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-2000.0);
    }

    public void update() {
        if (this.pending) {
            this.pending = false;
            this.achiTime = Minecraft.func_71386_F() + 5000L;
        }
        if (this.shouldRender && this.achiTime != 0L && Minecraft.func_71410_x().field_71439_g != null) {
            for (int k = 0; k < this.modUpdates.size(); ++k) {
                double d0 = (double)(Minecraft.func_71386_F() - this.achiTime) / (3000.0 + 500.0 * (double)(this.modUpdates.size() - 1));
                if ((d0 < -5.0 || d0 > 1.0) && k == this.modUpdates.size() - 1) {
                    this.shouldRender = false;
                    this.achiTime = 0L;
                    for (int l = 0; l < this.modUpdates.size(); ++l) {
                        String s = this.modUpdates.get(l);
                        iChunUtil.console("[NEW UPDATE AVAILABLE] " + s);
                    }
                    this.modUpdatesDone.addAll(this.modUpdates);
                    this.modUpdates.clear();
                    if (this.modUpdatesPending.isEmpty()) {
                        ModVersionChecker.differentDay = false;
                    }
                    while ((double)this.modUpdates.size() * 32.0 < (double)this.height && !this.modUpdatesPending.isEmpty()) {
                        this.modUpdates.add(this.modUpdatesPending.get(0));
                        this.modUpdatesPending.remove(0);
                        this.achiTime = Minecraft.func_71386_F();
                        Collections.sort(this.modUpdates);
                    }
                    this.shouldRender = true;
                    return;
                }
                this.updateWindowScale();
                GL11.glDisable((int)2929);
                GL11.glDepthMask((boolean)false);
                double d1 = d0 * 2.0;
                if (d1 > 1.0) {
                    d1 = 2.0 - d1;
                }
                d1 *= 4.0;
                if ((d1 = 1.0 - d1) < 0.0) {
                    d1 = 0.0;
                }
                d1 *= d1;
                d1 *= d1;
                int i = 0;
                int j = (int)(32.0 * (double)k * (1.0 - d1)) - (int)(d1 * 36.0);
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
                GL11.glEnable((int)3553);
                this.mc.func_110434_K().func_110577_a(rlAchievement);
                GL11.glDisable((int)2896);
                this.func_73729_b(i, j, 96, 202, 160, 32);
                this.mc.field_71466_p.func_78276_b(this.topText, i + 10, j + 7, -256);
                this.mc.field_71466_p.func_78276_b(this.modUpdates.get(k), i + 15, j + 18, -1);
                RenderHelper.func_74520_c();
                GL11.glDisable((int)2896);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2903);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2929);
            }
        }
    }

    public void clearModUpdates() {
        this.shouldRender = false;
        ModVersionChecker.clearListOfNonSidedMods(this.modUpdates);
        ModVersionChecker.clearListOfNonSidedMods(this.modUpdatesPending);
        this.modUpdatesDone.clear();
    }
}

