/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.client.gui.window.element;

import net.minecraft.client.gui.GuiTextField;
import us.ichun.mods.ichunutil.client.gui.Theme;
import us.ichun.mods.ichunutil.client.gui.window.Window;
import us.ichun.mods.ichunutil.client.gui.window.element.Element;
import us.ichun.mods.ichunutil.client.gui.window.element.ITextInput;
import us.ichun.mods.ichunutil.client.render.RendererHelper;

public class ElementTextInput
extends Element
implements ITextInput {
    public GuiTextField textField;
    public String tooltip;
    public int spacing;

    public ElementTextInput(Window window, int x, int y, int w, int h, int ID, String tip, int maxLength, String currentText) {
        super(window, x, y, w, 12, ID, false);
        this.textField = new GuiTextField(this.parent.workspace.getFontRenderer(), this.parent.posX + this.posX + 2, this.parent.posY + this.posY + 2, this.width - 9, this.parent.workspace.getFontRenderer().field_78288_b);
        this.textField.func_146203_f(maxLength);
        this.textField.func_146185_a(false);
        this.textField.func_146193_g(Theme.getAsHex(this.parent.workspace.currentTheme.font));
        this.textField.func_146205_d(false);
        this.textField.func_146180_a(currentText);
        this.tooltip = tip;
        this.spacing = this.parent.width - this.width - x;
    }

    public ElementTextInput(Window window, int x, int y, int w, int h, int ID, String tip, int maxLength) {
        this(window, x, y, w, h, ID, tip, maxLength, "");
    }

    public ElementTextInput(Window window, int x, int y, int w, int h, int ID, String tip) {
        this(window, x, y, w, h, ID, tip, 80, "");
    }

    public ElementTextInput(Window window, int x, int y, int w, int h, int ID, String tip, String currentText) {
        this(window, x, y, w, h, ID, tip, 80, currentText);
    }

    @Override
    public void update() {
        this.textField.func_146178_a();
        this.textField.func_146193_g(Theme.getAsHex(this.parent.workspace.currentTheme.font));
    }

    @Override
    public boolean onClick(int mouseX, int mouseY, int id) {
        if (id == 1) {
            this.textField.func_146180_a("");
        }
        if (this.textField.func_146206_l()) {
            this.textField.func_146192_a(this.parent.posX + mouseX + 2, this.parent.posY + mouseY + 2, id);
        }
        return true;
    }

    @Override
    public void draw(int mouseX, int mouseY, boolean hover) {
        RendererHelper.drawColourOnScreen(this.parent.workspace.currentTheme.elementInputBorder[0], this.parent.workspace.currentTheme.elementInputBorder[1], this.parent.workspace.currentTheme.elementInputBorder[2], 255, this.getPosX(), this.getPosY(), this.width, this.height, 0.0);
        if (hover) {
            RendererHelper.drawColourOnScreen(this.parent.workspace.currentTheme.elementInputBackgroundHover[0], this.parent.workspace.currentTheme.elementInputBackgroundHover[1], this.parent.workspace.currentTheme.elementInputBackgroundHover[2], 255, this.getPosX() + 1, this.getPosY() + 1, this.width - 2, this.height - 2, 0.0);
        } else {
            RendererHelper.drawColourOnScreen(this.parent.workspace.currentTheme.elementInputBackgroundInactive[0], this.parent.workspace.currentTheme.elementInputBackgroundInactive[1], this.parent.workspace.currentTheme.elementInputBackgroundInactive[2], 255, this.getPosX() + 1, this.getPosY() + 1, this.width - 2, this.height - 2, 0.0);
        }
        if (this.textField.func_146176_q()) {
            this.textField.func_146194_f();
        }
    }

    @Override
    public void keyInput(char c, int key) {
        if (key == 15) {
            this.tabHit();
            return;
        }
        if (key == 28) {
            this.parent.elementTriggered(this);
        }
        String prevText = this.textField.func_146179_b();
        this.textField.func_146201_a(c, key);
        this.checkAndCorrectText(prevText);
    }

    public void checkAndCorrectText(String oldText) {
    }

    @Override
    public void selected() {
        this.textField.func_146195_b(true);
    }

    @Override
    public void deselected() {
        this.textField.func_146195_b(false);
        this.resized();
    }

    @Override
    public void resized() {
        this.textField.field_146209_f = this.parent.posX + this.posX + 2;
        this.textField.field_146210_g = this.parent.posY + this.posY + 2;
        this.textField.field_146218_h = this.width - 9;
        this.textField.func_146196_d();
        this.width = this.parent.width - this.posX - this.spacing;
    }

    @Override
    public String tooltip() {
        return this.tooltip;
    }

    @Override
    public void tabHit() {
        Element e;
        int i;
        this.deselected();
        boolean found = false;
        boolean foundSelf = false;
        for (i = 0; i < this.parent.elements.size(); ++i) {
            e = this.parent.elements.get(i);
            if (e == this) {
                foundSelf = true;
                continue;
            }
            if (!(e instanceof ITextInput) || !foundSelf) continue;
            found = true;
            ((ITextInput)((Object)e)).cycledTo();
            break;
        }
        if (!found) {
            for (i = 0; i < this.parent.elements.size(); ++i) {
                e = this.parent.elements.get(i);
                if (!(e instanceof ITextInput)) continue;
                ((ITextInput)((Object)e)).cycledTo();
                break;
            }
        }
    }

    @Override
    public void cycledTo() {
        this.parent.workspace.elementSelected = this;
        this.selected();
    }
}

