/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.client.gui.window.element;

import net.minecraft.util.StatCollector;
import us.ichun.mods.ichunutil.client.gui.Theme;
import us.ichun.mods.ichunutil.client.gui.window.Window;
import us.ichun.mods.ichunutil.client.gui.window.WindowTabs;
import us.ichun.mods.ichunutil.client.gui.window.element.Element;
import us.ichun.mods.ichunutil.client.render.RendererHelper;

public class ElementWindow
extends Element {
    public Window mountedWindow;
    public int oriWidth;
    public int oriHeight;

    public ElementWindow(Window window, int x, int y, int w, int h, int ID, Window mount) {
        super(window, x, y, w, h, ID, true);
        this.mountedWindow = mount;
        this.oriWidth = this.mountedWindow.width;
        this.oriHeight = this.mountedWindow.height;
    }

    @Override
    public void update() {
        this.mountedWindow.update();
    }

    @Override
    public void draw(int mouseX, int mouseY, boolean hover) {
        String titleToRender = StatCollector.func_74838_a((String)this.mountedWindow.titleLocale);
        while (titleToRender.length() > 1 && this.parent.workspace.getFontRenderer().func_78256_a(titleToRender) > this.width && !titleToRender.startsWith("... ")) {
            if (titleToRender.endsWith("... ")) {
                titleToRender = titleToRender.substring(0, titleToRender.length() - 5) + "... ";
                continue;
            }
            titleToRender = titleToRender.substring(0, titleToRender.length() - 1) + "... ";
        }
        this.parent.workspace.getFontRenderer().func_85187_a(titleToRender, this.parent.posX + this.posX + 4, this.parent.posY + this.posY + 3, Theme.getAsHex(this.parent.workspace.currentTheme.font), false);
        this.mountedWindow.docked = this.parent.docked;
        this.mountedWindow.posX = this.parent.posX;
        this.mountedWindow.posY = this.parent.posY;
        this.mountedWindow.width = this.parent.width;
        this.mountedWindow.height = this.parent.height;
        if (this.parent instanceof WindowTabs) {
            WindowTabs tab = (WindowTabs)this.parent;
            if (tab.minimized && this.id != tab.tabs.size() - 1) {
                RendererHelper.drawColourOnScreen(this.parent.workspace.currentTheme.tabSideInactive[0], this.parent.workspace.currentTheme.tabSideInactive[1], this.parent.workspace.currentTheme.tabSideInactive[2], 255, this.getPosX() + this.width + 1, this.getPosY() + 1, 1.0, this.height, 0.0);
            }
            if (tab.selectedTab == this.id && !tab.minimized) {
                this.mountedWindow.isTab = true;
                this.mountedWindow.draw(mouseX, mouseY);
                this.mountedWindow.isTab = false;
                RendererHelper.drawColourOnScreen(this.parent.workspace.currentTheme.windowBorder[0], this.parent.workspace.currentTheme.windowBorder[1], this.parent.workspace.currentTheme.windowBorder[2], 255, this.getPosX(), this.getPosY() + 1 + this.height, this.width + 3, 2.0, 0.0);
            } else if (hover) {
                RendererHelper.drawColourOnScreen(this.parent.workspace.currentTheme.tabBorder[0], this.parent.workspace.currentTheme.tabBorder[1], this.parent.workspace.currentTheme.tabBorder[2], 255, this.getPosX() + 2, this.getPosY() + 1, this.width, 1.0, 0.0);
                RendererHelper.drawColourOnScreen(this.parent.workspace.currentTheme.tabBorder[0], this.parent.workspace.currentTheme.tabBorder[1], this.parent.workspace.currentTheme.tabBorder[2], 255, this.getPosX() + 2, this.getPosY() + 1, 1.0, this.height, 0.0);
                RendererHelper.drawColourOnScreen(this.parent.workspace.currentTheme.tabBorder[0], this.parent.workspace.currentTheme.tabBorder[1], this.parent.workspace.currentTheme.tabBorder[2], 255, this.getPosX() + 2, this.getPosY() + 1 + this.height - 1, this.width, 1.0, 0.0);
                RendererHelper.drawColourOnScreen(this.parent.workspace.currentTheme.tabBorder[0], this.parent.workspace.currentTheme.tabBorder[1], this.parent.workspace.currentTheme.tabBorder[2], 255, this.getPosX() + this.width + 1, this.getPosY() + 1, 1.0, this.height, 0.0);
            }
        }
    }

    @Override
    public void resized() {
        if (this.parent instanceof WindowTabs) {
            WindowTabs tab = (WindowTabs)this.parent;
            int space = tab.getWidth() - 3 * 2 - tab.workspace.getFontRenderer().func_78256_a("  _");
            int totalSpace = 0;
            for (ElementWindow tab1 : tab.tabs) {
                totalSpace += tab.workspace.getFontRenderer().func_78256_a(StatCollector.func_74838_a((String)tab1.mountedWindow.titleLocale) + " ");
            }
            if (totalSpace > space) {
                this.posX = 3 + this.id * (space / tab.tabs.size());
                this.posY = 0;
                this.width = space / tab.tabs.size();
                this.height = 12;
            } else {
                this.posX = 3;
                for (int i = 0; i < this.id; ++i) {
                    this.posX += tab.workspace.getFontRenderer().func_78256_a(StatCollector.func_74838_a((String)tab.tabs.get((int)i).mountedWindow.titleLocale) + " ");
                }
                this.posY = 0;
                this.width = tab.workspace.getFontRenderer().func_78256_a(StatCollector.func_74838_a((String)this.mountedWindow.titleLocale) + " ");
                this.height = 12;
            }
            this.mountedWindow.docked = this.parent.docked;
            this.mountedWindow.posX = this.parent.posX;
            this.mountedWindow.posY = this.parent.posY;
            this.mountedWindow.width = this.parent.width;
            this.mountedWindow.height = this.parent.height;
        }
        this.mountedWindow.resized();
    }

    @Override
    public String tooltip() {
        String titleToRender = StatCollector.func_74838_a((String)this.mountedWindow.titleLocale);
        if (this.parent.workspace.getFontRenderer().func_78256_a(titleToRender) > this.width) {
            return this.mountedWindow.titleLocale;
        }
        return null;
    }

    @Override
    public boolean onClick(int mouseX, int mouseY, int id) {
        if (id == 0 && this.parent instanceof WindowTabs) {
            ((WindowTabs)this.parent).selectedTab = this.id;
            if (this.parent.minimized) {
                this.parent.toggleMinimize();
            }
        }
        return true;
    }
}

