/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.core.updateChecker;

import com.google.gson.Gson;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import us.ichun.mods.ichunutil.common.core.updateChecker.ModVersionInfo;
import us.ichun.mods.ichunutil.common.core.util.EventCalendar;
import us.ichun.mods.ichunutil.common.iChunUtil;

public class ModVersionChecker {
    private static final String iChunJsonURL = "https://raw.github.com/iChun/iChunUtil/master/src/main/resources/assets/ichunutil/mod/versions.json";
    private static HashMap<String, ArrayList<ModVersionInfo>> urlsToCheck = new HashMap();
    private static boolean init = false;
    public static boolean differentDay;

    public static void init() {
        if (!init) {
            new Thread("iChunUtil Mod Version Check"){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    try {
                        for (Map.Entry e : urlsToCheck.entrySet()) {
                            void var4_6;
                            Gson gson = new Gson();
                            try {
                                InputStreamReader inputStreamReader = new InputStreamReader(new URL((String)e.getKey()).openStream());
                            }
                            catch (Exception e1) {
                                Object var4_8 = null;
                                e1.printStackTrace();
                            }
                            if (var4_6 == null) continue;
                            Map json = (Map)gson.fromJson((Reader)var4_6, Map.class);
                            for (ModVersionInfo info : (ArrayList)e.getValue()) {
                                Map versionInfo = (Map)json.get(info.modName);
                                if (versionInfo == null || !info.processAndReturnHasUpdate(versionInfo)) continue;
                                iChunUtil.proxy.notifyNewUpdate(info.modName, info.newModVersion);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    differentDay = iChunUtil.config.dayCheck != EventCalendar.day;
                    iChunUtil.config.dayCheck = EventCalendar.day;
                    StringBuilder sb = new StringBuilder();
                    ArrayList names = new ArrayList();
                    for (Map.Entry entry : iChunUtil.proxy.versionChecker.entrySet()) {
                        names.add(entry.getKey());
                    }
                    Collections.sort(names);
                    for (int i = 0; i < names.size(); ++i) {
                        sb.append((String)names.get(i));
                        sb.append(": ");
                        sb.append(iChunUtil.proxy.versionChecker.get(names.get(i)));
                        if (names.size() - 1 == i) continue;
                        sb.append(", ");
                    }
                    iChunUtil.config.lastCheck = sb.toString();
                    iChunUtil.config.save();
                }
            }.start();
        }
        init = true;
    }

    public static void registerModVersionToCheck(String url, ModVersionInfo info) {
        ArrayList<ModVersionInfo> list = ModVersionChecker.getArrayListForURL(url);
        list.add(info);
    }

    public static void register_iChunMod(ModVersionInfo info) {
        ArrayList<ModVersionInfo> list = ModVersionChecker.getArrayListForURL(iChunJsonURL);
        list.add(info);
    }

    public static ArrayList<ModVersionInfo> getListOf_iChunMods() {
        return ModVersionChecker.getArrayListForURL(iChunJsonURL);
    }

    private static ArrayList<ModVersionInfo> getArrayListForURL(String url) {
        ArrayList<ModVersionInfo> list = urlsToCheck.get(url);
        if (list == null) {
            list = new ArrayList();
            urlsToCheck.put(url, list);
        }
        return list;
    }

    public static void writeToBuffer(ByteBuf buffer) {
        for (Map.Entry<String, ArrayList<ModVersionInfo>> e : urlsToCheck.entrySet()) {
            for (ModVersionInfo info : e.getValue()) {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)info.modName);
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)info.modVersion);
            }
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)"##endPacket");
    }

    public static void compareServerVersions(HashMap<String, String> versions) {
        if (iChunUtil.proxy.tickHandlerClient.modUpdateNotification != null) {
            iChunUtil.proxy.tickHandlerClient.modUpdateNotification.clearModUpdates();
        }
        ArrayList infos = new ArrayList();
        for (Map.Entry<String, ArrayList<ModVersionInfo>> e : urlsToCheck.entrySet()) {
            for (ModVersionInfo info : e.getValue()) {
                String version = versions.get(info.modName);
                if (version == null || !info.isVersionOutdated(version)) continue;
                iChunUtil.proxy.notifyNewUpdate(info.modName, info.newModVersion);
            }
        }
    }

    public static void clearListOfNonSidedMods(ArrayList<String> list) {
        block0: for (int i = list.size() - 1; i >= 0; --i) {
            String modName = list.get(i);
            boolean br = false;
            for (Map.Entry<String, ArrayList<ModVersionInfo>> e : urlsToCheck.entrySet()) {
                for (ModVersionInfo info : e.getValue()) {
                    if (modName.startsWith(info.modName) && !info.sided) {
                        list.remove(i);
                        br = true;
                    }
                    if (!br) continue;
                    break;
                }
                if (!br) continue;
                continue block0;
            }
        }
    }
}

