/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.module.tabula.client.model;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.Entity;
import org.lwjgl.opengl.GL11;
import us.ichun.mods.ichunutil.common.module.tabula.common.project.ProjectInfo;
import us.ichun.mods.ichunutil.common.module.tabula.common.project.components.CubeGroup;
import us.ichun.mods.ichunutil.common.module.tabula.common.project.components.CubeInfo;

public class ModelTabula
extends ModelBase {
    public final ProjectInfo projectInfo;
    public ArrayList<CubeInfo> cubes;

    public ModelTabula(ProjectInfo info) {
        int i;
        this.projectInfo = info;
        this.field_78089_u = this.projectInfo.textureHeight;
        this.field_78090_t = this.projectInfo.textureWidth;
        this.cubes = new ArrayList();
        for (i = 0; i < this.projectInfo.cubeGroups.size(); ++i) {
            this.createGroupCubes(this.projectInfo.cubeGroups.get(i));
        }
        for (i = 0; i < this.projectInfo.cubes.size(); ++i) {
            this.projectInfo.cubes.get(i).createModel(this);
            this.cubes.add(this.projectInfo.cubes.get(i));
        }
    }

    public void func_78088_a(Entity ent, float f, float f1, float f2, float f3, float f4, float f5) {
        this.render(f5, false, false, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(float f5, boolean useTexture, boolean useOpacity) {
        this.render(f5, useTexture, useOpacity, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(float f5, boolean useTexture, boolean useOpacity, float r, float g, float b, float alpha) {
        if (useTexture && this.projectInfo.bufferedTexture != null) {
            if (this.projectInfo.bufferedTextureId == -1) {
                this.projectInfo.bufferedTextureId = TextureUtil.func_110987_a((int)TextureUtil.func_110996_a(), (BufferedImage)this.projectInfo.bufferedTexture);
            }
            GL11.glBindTexture((int)3553, (int)this.projectInfo.bufferedTextureId);
        }
        GL11.glPushMatrix();
        GL11.glScaled((double)(1.0 / this.projectInfo.scale[0]), (double)(1.0 / this.projectInfo.scale[1]), (double)(1.0 / this.projectInfo.scale[2]));
        for (CubeInfo info : this.cubes) {
            if (info.modelCube == null || info.hidden) continue;
            GL11.glPushMatrix();
            if (useOpacity) {
                GL11.glColor4d((double)r, (double)g, (double)b, (double)(alpha * (float)(info.opacity / 100.0)));
            }
            if (info.scale[0] != 1.0 || info.scale[1] != 1.0 || info.scale[2] != 1.0) {
                GL11.glTranslated((double)info.modelCube.field_82906_o, (double)info.modelCube.field_82908_p, (double)info.modelCube.field_82907_q);
                GL11.glTranslated((double)(info.modelCube.field_78800_c * f5), (double)(info.modelCube.field_78797_d * f5), (double)(info.modelCube.field_78798_e * f5));
                GL11.glScaled((double)info.scale[0], (double)info.scale[1], (double)info.scale[2]);
                GL11.glTranslated((double)(-info.modelCube.field_82906_o), (double)(-info.modelCube.field_82908_p), (double)(-info.modelCube.field_82907_q));
                GL11.glTranslated((double)(-info.modelCube.field_78800_c * f5), (double)(-info.modelCube.field_78797_d * f5), (double)(-info.modelCube.field_78798_e * f5));
            }
            info.modelCube.func_78785_a(f5);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    public void bindTexture(BufferedImage image) {
        this.projectInfo.bufferedTexture = image;
        this.projectInfo.bufferedTextureId = TextureUtil.func_110987_a((int)TextureUtil.func_110996_a(), (BufferedImage)this.projectInfo.bufferedTexture);
    }

    private void createGroupCubes(CubeGroup group) {
        int i;
        for (i = 0; i < group.cubeGroups.size(); ++i) {
            this.createGroupCubes(group.cubeGroups.get(i));
        }
        for (i = 0; i < group.cubes.size(); ++i) {
            group.cubes.get(i).createModel(this);
            this.cubes.add(group.cubes.get(i));
        }
    }
}

