/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.module.tabula.common.math;

public class PolynomialFunctionLagrangeForm {
    private final double[] x;
    private final double[] y;

    public PolynomialFunctionLagrangeForm(double[] x, double[] y) {
        this.x = new double[x.length];
        this.y = new double[y.length];
        System.arraycopy(x, 0, this.x, 0, x.length);
        System.arraycopy(y, 0, this.y, 0, y.length);
    }

    public double value(double z) {
        return PolynomialFunctionLagrangeForm.evaluateInternal(this.x, this.y, z);
    }

    private static double evaluateInternal(double[] x, double[] y, double z) {
        int nearest = 0;
        int n = x.length;
        double[] c = new double[n];
        double[] d = new double[n];
        double min_dist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            c[i] = y[i];
            d[i] = y[i];
            double dist = Double.longBitsToDouble(Long.MAX_VALUE & Double.doubleToRawLongBits(z - x[i]));
            if (!(dist < min_dist)) continue;
            nearest = i;
            min_dist = dist;
        }
        double value = y[nearest];
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < n - i; ++j) {
                double tc = x[j] - z;
                double td = x[i + j] - z;
                double divider = x[j] - x[i + j];
                double w = (c[j + 1] - d[j]) / divider;
                c[j] = tc * w;
                d[j] = td * w;
            }
            if ((double)nearest < 0.5 * (double)(n - i + 1)) {
                value += c[nearest];
                continue;
            }
            value += d[--nearest];
        }
        return value;
    }
}

