/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.keygrip.client.gui.window;

import java.io.File;
import net.minecraft.util.StatCollector;
import us.ichun.mods.ichunutil.client.gui.Theme;
import us.ichun.mods.ichunutil.client.gui.window.IWorkspace;
import us.ichun.mods.ichunutil.client.gui.window.Window;
import us.ichun.mods.ichunutil.client.gui.window.WindowPopup;
import us.ichun.mods.ichunutil.client.gui.window.element.Element;
import us.ichun.mods.ichunutil.client.gui.window.element.ElementButton;
import us.ichun.mods.ichunutil.client.gui.window.element.ElementTextInput;
import us.ichun.mods.ichunutil.client.gui.window.element.ElementTextInputSaveAs;
import us.ichun.mods.ichunutil.common.core.util.IOUtil;
import us.ichun.mods.keygrip.client.core.ResourceHelper;
import us.ichun.mods.keygrip.client.gui.GuiWorkspace;
import us.ichun.mods.keygrip.client.gui.window.WindowOverwrite;
import us.ichun.mods.keygrip.common.scene.Scene;

public class WindowSaveAs
extends Window {
    private static final String[] invalidChars = new String[]{"\\\\", "/", ":", "\\*", "\\?", "\"", "<", ">", "|"};
    public boolean shouldClose;
    public boolean closeProject;

    public WindowSaveAs(IWorkspace parent, int x, int y, int w, int h, int minW, int minH, boolean close) {
        super(parent, x, y, w, h, minW, minH, "window.saveAs.title", true);
        Scene project = ((GuiWorkspace)this.workspace).sceneManager.scenes.get(((GuiWorkspace)this.workspace).sceneManager.selectedScene);
        this.elements.add(new ElementTextInputSaveAs((Window)this, 10, 30, this.width - 20, 12, 1, "window.saveAs.fileName", project.name.replaceAll("[^A-Za-z0-9()\\[\\]]", "")));
        this.elements.add(new ElementButton(this, this.width - 140, this.height - 30, 60, 16, 3, false, 1, 1, "element.button.ok"));
        this.elements.add(new ElementButton(this, this.width - 70, this.height - 30, 60, 16, 0, false, 1, 1, "element.button.cancel"));
        this.closeProject = close;
    }

    @Override
    public void update() {
        if (this.shouldClose) {
            this.workspace.removeWindow(this, true);
            if (this.closeProject && !((GuiWorkspace)this.workspace).sceneManager.scenes.isEmpty()) {
                ((GuiWorkspace)this.workspace).sceneManager.removeScene(((GuiWorkspace)this.workspace).sceneManager.scenes.get((int)((GuiWorkspace)this.workspace).sceneManager.selectedScene).identifier);
            }
        }
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        super.draw(mouseX, mouseY);
        if (!this.minimized) {
            this.workspace.getFontRenderer().func_85187_a(StatCollector.func_74838_a((String)"window.saveAs.fileName"), this.posX + 11, this.posY + 20, Theme.getAsHex(this.workspace.currentTheme.font), false);
        }
    }

    @Override
    public void elementTriggered(Element element) {
        if (element.id == 0) {
            this.workspace.removeWindow(this, true);
        }
        if (element.id == 3) {
            String projName = "";
            for (int i = 0; i < this.elements.size(); ++i) {
                if (!(this.elements.get(i) instanceof ElementTextInput)) continue;
                ElementTextInput text = (ElementTextInput)this.elements.get(i);
                if (text.id != 1) continue;
                projName = text.textField.func_146179_b();
            }
            if (projName.isEmpty()) {
                return;
            }
            if (!projName.endsWith(".kgs")) {
                projName = projName + ".kgs";
            }
            File file = new File(ResourceHelper.getScenesDir(), projName);
            Scene scene = ((GuiWorkspace)this.workspace).sceneManager.scenes.get(((GuiWorkspace)this.workspace).sceneManager.selectedScene);
            if (this.workspace.windowDragged == this) {
                this.workspace.windowDragged = null;
            }
            if (file.exists()) {
                this.workspace.addWindowOnTop(new WindowOverwrite(this.workspace, this, scene, file).putInMiddleOfScreen());
            } else if (Scene.saveScene(scene, file)) {
                scene.saveFile = file;
                scene.saveFileMd5 = IOUtil.getMD5Checksum(file);
                Scene.saveSceneActions(scene);
                this.workspace.removeWindow(this, true);
                if (this.closeProject && !((GuiWorkspace)this.workspace).sceneManager.scenes.isEmpty()) {
                    ((GuiWorkspace)this.workspace).sceneManager.removeScene(scene.identifier);
                }
            } else {
                this.workspace.addWindowOnTop(new WindowPopup(this.workspace, 0, 0, 180, 80, 180, 80, "window.saveAs.failed").putInMiddleOfScreen());
            }
        }
    }
}

