/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.keygrip.client.gui.window.element;

import java.io.File;
import us.ichun.mods.ichunutil.client.gui.Theme;
import us.ichun.mods.ichunutil.client.gui.window.Window;
import us.ichun.mods.ichunutil.client.gui.window.element.Element;
import us.ichun.mods.ichunutil.client.render.RendererHelper;
import us.ichun.mods.ichunutil.common.core.util.IOUtil;
import us.ichun.mods.keygrip.client.core.ResourceHelper;
import us.ichun.mods.keygrip.client.gui.window.WindowSaveBeforeClosing;
import us.ichun.mods.keygrip.client.gui.window.WindowSceneSelection;
import us.ichun.mods.keygrip.common.scene.Scene;

public class ElementSceneTab
extends Element {
    public Scene info;
    public boolean changed;

    public ElementSceneTab(Window window, int x, int y, int w, int h, int ID, Scene inf) {
        super(window, x, y, w, h, ID, true);
        this.info = inf;
        this.changed = false;
    }

    @Override
    public void draw(int mouseX, int mouseY, boolean hover) {
        WindowSceneSelection proj = (WindowSceneSelection)this.parent;
        if (this.id != proj.scenes.size() - 1) {
            RendererHelper.drawColourOnScreen(this.parent.workspace.currentTheme.tabSideInactive[0], this.parent.workspace.currentTheme.tabSideInactive[1], this.parent.workspace.currentTheme.tabSideInactive[2], 255, this.getPosX() + this.width - 1, this.getPosY() + 1, 1.0, this.height, 0.0);
        }
        if (proj.selectedScene == this.id) {
            RendererHelper.drawColourOnScreen(this.parent.workspace.currentTheme.elementProjectTabActive[0], this.parent.workspace.currentTheme.elementProjectTabActive[1], this.parent.workspace.currentTheme.elementProjectTabActive[2], 255, this.getPosX(), this.getPosY(), this.width - 1, this.height, 0.0);
        } else if (hover) {
            RendererHelper.drawColourOnScreen(this.parent.workspace.currentTheme.elementProjectTabHover[0], this.parent.workspace.currentTheme.elementProjectTabHover[1], this.parent.workspace.currentTheme.elementProjectTabHover[2], 255, this.getPosX(), this.getPosY(), this.width - 1, this.height, 0.0);
        }
        String titleToRender = this.info.name;
        while (titleToRender.length() > 1 && this.parent.workspace.getFontRenderer().func_78256_a(titleToRender) > this.width - 11 && !titleToRender.startsWith("... ")) {
            if (titleToRender.endsWith("... ")) {
                titleToRender = titleToRender.substring(0, titleToRender.length() - 5) + "... ";
                continue;
            }
            titleToRender = titleToRender.substring(0, titleToRender.length() - 1) + "... ";
        }
        this.parent.workspace.getFontRenderer().func_85187_a(titleToRender, this.parent.posX + this.posX + 4, this.parent.posY + this.posY + 3, Theme.getAsHex(this.changed ? this.parent.workspace.currentTheme.elementProjectTabFontChanges : this.parent.workspace.currentTheme.elementProjectTabFont), false);
        this.parent.workspace.getFontRenderer().func_85187_a("X", this.parent.posX + this.posX + this.width - 8, this.parent.posY + this.posY + 3, Theme.getAsHex(this.parent.workspace.currentTheme.elementProjectTabFont), false);
    }

    @Override
    public void resized() {
        WindowSceneSelection tab = (WindowSceneSelection)this.parent;
        int space = tab.getWidth();
        int totalSpace = 0;
        for (Scene tab1 : tab.scenes) {
            totalSpace += tab.workspace.getFontRenderer().func_78256_a(" " + tab1.name + " X ");
        }
        if (totalSpace > space) {
            this.posX = this.id * (space / tab.scenes.size());
            this.posY = 0;
            this.width = space / tab.scenes.size();
            this.height = 12;
        } else {
            this.posX = 0;
            for (int i = 0; i < this.id; ++i) {
                this.posX += tab.workspace.getFontRenderer().func_78256_a(" " + tab.scenes.get((int)i).name + " X ");
            }
            this.posY = 0;
            this.width = tab.workspace.getFontRenderer().func_78256_a(" " + this.info.name + " X ");
            this.height = 12;
        }
    }

    @Override
    public String tooltip() {
        String tooltip = this.info.name;
        if (this.info.saveFile != null) {
            tooltip = tooltip + " - " + this.info.saveFile.getName();
        }
        return tooltip;
    }

    @Override
    public boolean onClick(int mouseX, int mouseY, int id) {
        if (id == 0 || id == 2) {
            ((WindowSceneSelection)this.parent).changeScene(this.id);
            if (mouseX + this.parent.posX > this.getPosX() + this.width - 9 || id == 2) {
                Scene scene = ((WindowSceneSelection)this.parent).scenes.get(this.id);
                String md5 = null;
                File temp = new File(ResourceHelper.getTempDir(), Integer.toString(Math.abs(scene.hashCode())) + ".kgs");
                if (Scene.saveScene(scene, temp)) {
                    md5 = IOUtil.getMD5Checksum(temp);
                    temp.delete();
                }
                if (scene.saveFile == null || scene.saveFileMd5 == null || !scene.saveFileMd5.equals(md5)) {
                    this.parent.workspace.addWindowOnTop(new WindowSaveBeforeClosing(this.parent.workspace, scene).putInMiddleOfScreen());
                } else {
                    ((WindowSceneSelection)this.parent).removeScene(scene.identifier);
                }
            }
        }
        return false;
    }
}

