/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.core.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.ReportedException;
import us.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import us.ichun.mods.ichunutil.common.core.network.PacketChannel;
import us.ichun.mods.ichunutil.common.iChunUtil;

public class ChannelHandler
extends FMLIndexedMessageToMessageCodec<AbstractPacket> {
    public final String channel;

    private ChannelHandler(String s, Class<? extends AbstractPacket> ... packetTypes) {
        this.channel = s;
        ArrayList<Class<? extends AbstractPacket>> list = new ArrayList<Class<? extends AbstractPacket>>();
        for (int i = 0; i < packetTypes.length; ++i) {
            if (!list.contains(packetTypes[i])) {
                list.add(packetTypes[i]);
            } else {
                iChunUtil.console("Channel " + this.channel + " is reregistering packet types!", true);
            }
            this.addDiscriminator(i, packetTypes[i]);
        }
    }

    public static PacketChannel getChannelHandlers(String modId, Class<? extends AbstractPacket> ... packetTypes) {
        if (packetTypes.length == 0) {
            throw new ReportedException(new CrashReport("Mod " + modId + " is not registering any packets with its channel handlers.", new Throwable()));
        }
        EnumMap handlers = NetworkRegistry.INSTANCE.newChannel(modId, new io.netty.channel.ChannelHandler[]{new ChannelHandler(modId, packetTypes)});
        PacketChannel channel1 = new PacketChannel(modId, handlers, packetTypes);
        PacketExecuter executer = new PacketExecuter(channel1);
        for (Map.Entry e : handlers.entrySet()) {
            FMLEmbeddedChannel channel = (FMLEmbeddedChannel)e.getValue();
            String codec = channel.findChannelHandlerNameForType(ChannelHandler.class);
            channel.pipeline().addAfter(codec, "PacketExecuter", (io.netty.channel.ChannelHandler)executer);
        }
        PacketChannel.registeredChannels.add(channel1);
        return channel1;
    }

    public void encodeInto(ChannelHandlerContext ctx, AbstractPacket msg, ByteBuf target) throws Exception {
        try {
            msg.writeTo(target, (Side)ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get());
        }
        catch (Exception e) {
            iChunUtil.console("Error writing to packet for channel: " + this.channel, true);
            e.printStackTrace();
        }
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, AbstractPacket msg) {
        try {
            msg.readFrom(source, (Side)ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get());
        }
        catch (Exception e) {
            iChunUtil.console("Error reading from packet for channel: " + this.channel, true);
            e.printStackTrace();
        }
    }

    @ChannelHandler.Sharable
    private static class PacketExecuter
    extends SimpleChannelInboundHandler<AbstractPacket> {
        private final PacketChannel channel;

        public PacketExecuter(PacketChannel channel) {
            this.channel = channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void channelRead0(ChannelHandlerContext ctx, AbstractPacket msg) throws Exception {
            Side side = (Side)ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get();
            EntityPlayer player = null;
            if (side.isServer()) {
                INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                player = ((NetHandlerPlayServer)netHandler).field_147369_b;
            } else {
                player = this.getClientPlayer();
            }
            if (!msg.requiresMainThread()) {
                msg.execute(side, player);
            } else {
                if (side.isServer()) {
                    msg.playerServer = player;
                } else {
                    msg.playerClient = player;
                }
                Map<Side, ArrayList<AbstractPacket>> map = this.channel.queuedPackets;
                synchronized (map) {
                    this.channel.queuedPackets.get(side).add(msg);
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public EntityPlayer getClientPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }
    }
}

