/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.core.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import us.ichun.mods.ichunutil.common.core.network.AbstractPacket;

public class PacketChannel {
    public static ArrayList<PacketChannel> registeredChannels = new ArrayList();
    private final String modId;
    private final EnumMap<Side, FMLEmbeddedChannel> channels;
    private final Class<? extends AbstractPacket>[] packetTypes;
    public final Map<Side, ArrayList<AbstractPacket>> queuedPackets = Collections.synchronizedMap(new EnumMap<Side, ArrayList<AbstractPacket>>(Side.class){
        {
            this.put(Side.CLIENT, new ArrayList());
            this.put(Side.SERVER, new ArrayList());
        }
    });

    protected PacketChannel(String id, EnumMap<Side, FMLEmbeddedChannel> chans, Class<? extends AbstractPacket>[] types) {
        this.modId = id;
        this.channels = chans;
        this.packetTypes = types;
    }

    public EnumMap<Side, FMLEmbeddedChannel> getChannels() {
        return this.channels;
    }

    public String getModId() {
        return this.modId;
    }

    public void sendToAll(AbstractPacket packet) {
        this.validatePacket(packet);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToPlayer(AbstractPacket packet, EntityPlayer player) {
        this.validatePacket(packet);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToAllAround(AbstractPacket packet, NetworkRegistry.TargetPoint point) {
        this.validatePacket(packet);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToDimension(AbstractPacket packet, int dimension) {
        this.validatePacket(packet);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimension);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToServer(AbstractPacket packet) {
        this.validatePacket(packet);
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)packet);
    }

    public void sendToAllExcept(AbstractPacket packet, EntityPlayer player) {
        this.validatePacket(packet);
        for (int i = 0; i < FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b.size(); ++i) {
            EntityPlayer player1 = (EntityPlayer)FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().field_72404_b.get(i);
            if (player.func_70005_c_().equalsIgnoreCase(player1.func_70005_c_())) continue;
            this.sendToPlayer(packet, player1);
        }
    }

    private void validatePacket(AbstractPacket packet) {
        boolean has = false;
        Class<?> clz = packet.getClass();
        for (Class<? extends AbstractPacket> type : this.packetTypes) {
            if (type != clz) continue;
            has = true;
            break;
        }
        if (!has) {
            throw new RuntimeException("Sending a packet that is not registered!");
        }
    }
}

