/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import us.ichun.mods.ichunutil.common.core.CommonProxy;
import us.ichun.mods.ichunutil.common.core.EventHandler;
import us.ichun.mods.ichunutil.common.core.config.ConfigBase;
import us.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import us.ichun.mods.ichunutil.common.core.config.annotations.ConfigProp;
import us.ichun.mods.ichunutil.common.core.config.annotations.IntBool;
import us.ichun.mods.ichunutil.common.core.config.annotations.IntMinMax;
import us.ichun.mods.ichunutil.common.core.network.PacketChannel;
import us.ichun.mods.ichunutil.common.core.network.PacketExecuter;
import us.ichun.mods.ichunutil.common.core.patron.PatronInfo;
import us.ichun.mods.ichunutil.common.core.updateChecker.ModVersionChecker;
import us.ichun.mods.ichunutil.common.core.updateChecker.ModVersionInfo;
import us.ichun.mods.ichunutil.common.core.util.ObfHelper;

@Mod(modid="iChunUtil", name="iChunUtil", version="5.3.0", dependencies="required-after:Forge@[1.8-11.14.1.1329,)")
public class iChunUtil {
    public static final int versionMC = 5;
    public static final String versionOfMC = "1.8.0";
    public static final String version = "5.3.0";
    private static boolean hasPostLoad = false;
    private static Logger logger = LogManager.getLogger((String)"iChunUtil");
    public static PacketChannel channel;
    public static Config config;
    public static boolean hasMorphMod;
    public static boolean isPatron;
    public static ArrayList<PatronInfo> patronList;
    @Mod.Instance(value="iChunUtil")
    public static iChunUtil instance;
    @SidedProxy(clientSide="us.ichun.mods.ichunutil.client.core.ClientProxy", serverSide="us.ichun.mods.ichunutil.common.core.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent event) {
        String[] split;
        ObfHelper.detectObfuscation();
        FMLCommonHandler.instance().bus().register((Object)new PacketExecuter());
        EventHandler eventHandler = new EventHandler();
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        config = (Config)ConfigHandler.registerConfig(new Config(event.getSuggestedConfigurationFile()));
        for (String s : split = iChunUtil.config.lastCheck.split(", ")) {
            String[] str = s.split(": ");
            if (str.length < 2) continue;
            iChunUtil.proxy.prevVerChecker.put(str[0], str[1]);
        }
        proxy.preInit();
        ModVersionChecker.register_iChunMod(new ModVersionInfo("iChunUtil", versionOfMC, version, false));
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.init();
        ModVersionChecker.init();
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent event) {
        proxy.postInit();
        hasPostLoad = true;
        for (ConfigBase cfg : ConfigHandler.configs) {
            cfg.setup();
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && ConfigHandler.configKeybind != null) {
            ConfigHandler.configKeybind.save();
        }
        hasMorphMod = Loader.isModLoaded((String)"Morph");
    }

    public static boolean getPostLoad() {
        return hasPostLoad;
    }

    public static void console(String s, boolean warning) {
        StringBuilder sb = new StringBuilder();
        logger.log(warning ? Level.WARN : Level.INFO, sb.append("[").append(version).append("] ").append(s).toString());
    }

    public static void console(String s) {
        iChunUtil.console(s, false);
    }

    static {
        patronList = new ArrayList();
    }

    public class Config
    extends ConfigBase {
        @ConfigProp(category="versionCheck")
        @IntMinMax(min=0, max=2)
        public int versionNotificationTypes;
        @ConfigProp(category="versionCheck")
        @IntMinMax(min=0, max=3)
        public int versionNotificationFrequency;
        @ConfigProp(category="versionSave", comment="", nameOverride="Last Check")
        public String lastCheck;
        @ConfigProp(category="versionSave", comment="", nameOverride="Day Check")
        @IntMinMax(min=0, max=35)
        public int dayCheck;
        @ConfigProp(category="patreon", hidden=true)
        @IntBool
        public int showPatronReward;
        @ConfigProp(category="patreon", hidden=true)
        @IntMinMax(min=1, max=2)
        public int patronRewardType;
        @ConfigProp(useSession=true, category="block")
        @IntBool
        public int enableCompactPorkchop;

        public Config(File file) {
            super(file, new String[0]);
            this.versionNotificationTypes = 1;
            this.versionNotificationFrequency = 0;
            this.lastCheck = "";
            this.dayCheck = 0;
            this.showPatronReward = 1;
            this.patronRewardType = 1;
            this.enableCompactPorkchop = 1;
        }

        @Override
        public String getModId() {
            return "ichunutil";
        }

        @Override
        public String getModName() {
            return "iChunUtil";
        }

        @Override
        public void onConfigChange(Field field, Object original) {
            if (field.getName().equals("showPatronReward") || field.getName().equals("patronRewardType")) {
                iChunUtil.proxy.trailTicker.tellServerAsPatron = true;
            }
        }
    }
}

