/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.module.tabula.client.formats;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import us.ichun.mods.ichunutil.common.iChunUtil;
import us.ichun.mods.ichunutil.common.module.tabula.client.formats.types.ImportTabula;
import us.ichun.mods.ichunutil.common.module.tabula.client.formats.types.Importer;
import us.ichun.mods.ichunutil.common.module.tabula.common.project.ProjectInfo;

public class ImportList {
    public static final ImportTabula tabulaImporterInstance = new ImportTabula();
    public static final HashMap<String, Importer> compatibleFormats = new HashMap<String, Importer>(){
        {
            this.put("tcn", tabulaImporterInstance);
            this.put("tc2", tabulaImporterInstance);
            this.put("tbl", tabulaImporterInstance);
        }
    };

    public static boolean isFileSupported(File file) {
        return !file.isDirectory() && compatibleFormats.containsKey(FilenameUtils.getExtension((String)file.getName()));
    }

    public static ProjectInfo createProjectFromFile(File file) {
        if (compatibleFormats.containsKey(FilenameUtils.getExtension((String)file.getName()))) {
            Importer importer = compatibleFormats.get(FilenameUtils.getExtension((String)file.getName()));
            try {
                ProjectInfo projectInfo = importer.createProjectInfo(file);
                projectInfo.projVersion = importer.getProjectVersion();
                projectInfo.repair();
                return projectInfo;
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder();
                sb.append("Error creating Project for format ").append(FilenameUtils.getExtension((String)file.getName())).append(" for file ").append(file.getAbsolutePath()).append(" by importer ").append(importer);
                iChunUtil.console(sb.toString(), true);
                return null;
            }
        }
        return null;
    }

    public static boolean registerImporter(String format, Importer importer) {
        if (compatibleFormats.containsKey(format)) {
            return false;
        }
        compatibleFormats.put(format, importer);
        return true;
    }
}

