/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.keygrip.client.gui.window;

import java.util.ArrayList;
import us.ichun.mods.ichunutil.client.gui.window.Window;
import us.ichun.mods.ichunutil.client.gui.window.element.Element;
import us.ichun.mods.ichunutil.client.render.RendererHelper;
import us.ichun.mods.keygrip.client.gui.GuiWorkspace;
import us.ichun.mods.keygrip.client.gui.window.WindowTopDock;
import us.ichun.mods.keygrip.client.gui.window.element.ElementSceneTab;
import us.ichun.mods.keygrip.common.scene.Scene;

public class WindowSceneSelection
extends WindowTopDock {
    public ArrayList<Scene> scenes = new ArrayList();
    public int selectedScene;

    public WindowSceneSelection(GuiWorkspace parent, int w, int h) {
        super(parent, w, h);
        this.elements.clear();
        this.selectedScene = -1;
    }

    @Override
    public void elementTriggered(Element element) {
        this.selectedScene = element.id;
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        if (this.scenes.isEmpty() || this.width <= 0) {
            return;
        }
        super.draw(mouseX, mouseY);
        RendererHelper.drawColourOnScreen(this.workspace.currentTheme.tabSideInactive[0], this.workspace.currentTheme.tabSideInactive[1], this.workspace.currentTheme.tabSideInactive[2], 255, this.posX, this.posY, this.width, 1.0, 0.0);
    }

    @Override
    public void resized() {
        for (Element element : this.elements) {
            element.resized();
        }
        this.posX = !this.workspace.levels.get(0).isEmpty() ? this.workspace.levels.get((int)0).get((int)0).width - 2 : 0;
        this.posY = this.workspace.TOP_DOCK_HEIGHT + 1;
        this.width = !this.workspace.levels.get(1).isEmpty() ? this.workspace.field_146294_l - this.posX - this.workspace.levels.get((int)1).get((int)0).width + 2 : this.workspace.field_146294_l - this.posX;
        this.height = 12;
    }

    @Override
    public void shutdown() {
        for (Scene scene : this.scenes) {
            scene.destroy();
        }
    }

    public void addScene(Scene scene) {
        this.scenes.add(scene);
        this.elements.add(new ElementSceneTab((Window)this, 0, 0, 10, 10, this.elements.size(), scene));
        if (this.scenes.size() == 1) {
            this.changeScene(this.scenes.size() - 1);
        }
        this.resized();
    }

    public void removeScene(String ident) {
        int i;
        for (int i2 = this.scenes.size() - 1; i2 >= 0; --i2) {
            Scene project = this.scenes.get(i2);
            if (!project.identifier.equals(ident)) continue;
            project.destroy();
            this.scenes.remove(i2);
            if (i2 == this.selectedScene || this.selectedScene == this.scenes.size()) {
                --this.selectedScene;
                if (this.selectedScene < 0 && !this.scenes.isEmpty()) {
                    this.selectedScene = 0;
                }
            }
            this.changeScene(this.selectedScene);
            break;
        }
        ArrayList els = new ArrayList(this.elements);
        for (i = this.scenes.size() - 1; i >= 0; --i) {
            Scene project = this.scenes.get(i);
            for (Element e : this.elements) {
                if (!(e instanceof ElementSceneTab)) continue;
                ElementSceneTab tab = (ElementSceneTab)e;
                if (!tab.info.identifier.equals(project.identifier)) continue;
                tab.id = i;
                els.remove(e);
            }
        }
        for (i = els.size() - 1; i >= 0; --i) {
            if (!(els.get(i) instanceof ElementSceneTab)) continue;
            this.elements.remove(els.get(i));
        }
        this.resized();
    }

    public void changeScene(Scene info) {
        for (int i = 0; i < this.scenes.size(); ++i) {
            if (this.scenes.get(i) != info) continue;
            this.changeScene(i);
            return;
        }
    }

    public void changeScene(int i) {
        this.selectedScene = i;
        this.parent.timeline.timeline.selectedIdentifier = "";
        this.parent.timeline.timeline.setCurrentPos(0);
        this.parent.timeline.timeline.focusOnTicker();
    }

    @Override
    public int getHeight() {
        return 12;
    }
}

