/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.keygrip.common.core;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.io.FileUtils;
import us.ichun.mods.keygrip.client.core.ResourceHelper;
import us.ichun.mods.keygrip.common.Keygrip;
import us.ichun.mods.keygrip.common.packet.PacketSceneStatus;
import us.ichun.mods.keygrip.common.scene.Scene;

public class TickHandlerServer {
    public HashMap<String, ArrayList<byte[]>> sceneParts = new HashMap();
    public ArrayList<Scene> scenesToPlay = new ArrayList();

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            for (int i = this.scenesToPlay.size() - 1; i >= 0; --i) {
                Scene scene = this.scenesToPlay.get(i);
                scene.update();
                if (scene.playTime <= scene.getLength() + 10) continue;
                scene.stop();
                scene.destroy();
                this.scenesToPlay.remove(i);
                Keygrip.channel.sendToAll(new PacketSceneStatus(scene.playTime, scene.identifier, false));
            }
        }
    }

    public void receiveProjectData(int dimension, int startPoint, String sceneIdent, short packetTotal, short packetNumber, byte[] data) {
        Object byteList;
        ArrayList<Object> byteArray = this.sceneParts.get(sceneIdent);
        if (byteArray == null) {
            byteArray = new ArrayList();
            this.sceneParts.put(sceneIdent, byteArray);
            for (int i = 0; i < packetTotal; ++i) {
                byteArray.add(new byte[0]);
            }
        }
        byteArray.set(packetNumber, data);
        boolean hasAllInfo = true;
        for (int i = 0; i < byteArray.size(); ++i) {
            byteList = (byte[])byteArray.get(i);
            if (((byte[])byteList).length != 0) continue;
            hasAllInfo = false;
        }
        if (hasAllInfo) {
            int size = 0;
            byteList = byteArray.iterator();
            while (byteList.hasNext()) {
                byte[] aByteArray = (byte[])byteList.next();
                size += aByteArray.length;
            }
            byte[] bytes = new byte[size];
            int index = 0;
            for (int i = 0; i < byteArray.size(); ++i) {
                System.arraycopy(byteArray.get(i), 0, bytes, index, ((byte[])byteArray.get(i)).length);
                index += ((byte[])byteArray.get(i)).length;
            }
            File temp = new File(ResourceHelper.getTempDir(), Integer.toString(Math.abs(sceneIdent.hashCode())) + "-received.kgs");
            try {
                FileUtils.writeByteArrayToFile((File)temp, (byte[])bytes);
                if (temp.exists()) {
                    Scene scene = Scene.openScene(temp);
                    if (scene != null) {
                        for (int i = this.scenesToPlay.size() - 1; i >= 0; --i) {
                            Scene scener = this.scenesToPlay.get(i);
                            if (!scener.identifier.equals(scene.identifier)) continue;
                            scener.stop();
                            scener.destroy();
                            this.scenesToPlay.remove(i);
                        }
                        scene.playing = true;
                        scene.playTime = startPoint;
                        this.scenesToPlay.add(scene);
                        Keygrip.channel.sendToDimension(new PacketSceneStatus(startPoint, sceneIdent, true), dimension);
                        scene.create(DimensionManager.getWorld((int)dimension));
                    }
                    temp.delete();
                }
            }
            catch (IOException ignored) {
                ignored.printStackTrace();
            }
            this.sceneParts.remove(sceneIdent);
        }
    }
}

