/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.keygrip.common.scene.action;

import com.google.common.collect.Ordering;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S04PacketEntityEquipment;
import net.minecraft.network.play.server.S19PacketEntityStatus;
import net.minecraft.network.play.server.S38PacketPlayerListItem;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.RandomStringUtils;
import us.ichun.mods.ichunutil.common.core.EntityHelperBase;
import us.ichun.mods.ichunutil.common.core.util.IOUtil;
import us.ichun.mods.ichunutil.common.network.FakeNetHandlerPlayServer;
import us.ichun.mods.keygrip.common.Keygrip;
import us.ichun.mods.keygrip.common.packet.PacketToggleSleeping;
import us.ichun.mods.keygrip.common.scene.Scene;
import us.ichun.mods.keygrip.common.scene.action.ActionComponent;
import us.ichun.mods.keygrip.common.scene.action.EntityState;
import us.ichun.mods.keygrip.common.scene.action.LimbComponent;

public class Action
implements Comparable {
    public static final int VERSION = 1;
    @SerializedName(value="n")
    public String name;
    @SerializedName(value="i")
    public String identifier;
    @SerializedName(value="t")
    public String entityType;
    @SerializedName(value="k")
    public int startKey;
    @SerializedName(value="nbt")
    public byte[] nbtToRead;
    @SerializedName(value="v")
    public int version = 1;
    @SerializedName(value="p")
    public int precreateEntity;
    @SerializedName(value="P")
    public int persistEntity;
    @SerializedName(value="h")
    public int hidden;
    @SerializedName(value="s")
    public int[] offsetPos = new int[3];
    @SerializedName(value="r")
    public int[] rotation = new int[2];
    @SerializedName(value="ac")
    public TreeMap<Integer, ArrayList<ActionComponent>> actionComponents = new TreeMap(Ordering.natural());
    @SerializedName(value="al")
    public TreeMap<Integer, LimbComponent> lookComponents = new TreeMap(Ordering.natural());
    @SerializedName(value="ap")
    public TreeMap<Integer, LimbComponent> posComponents = new TreeMap(Ordering.natural());
    public transient EntityState state;

    public Action(String name, String type, int startKey, NBTTagCompound tag, boolean preCreate, boolean persist) {
        this.identifier = RandomStringUtils.randomAscii((int)20);
        this.update(name, type, startKey, tag, preCreate, persist);
    }

    public void update(String name, String type, int startKey, NBTTagCompound tag, boolean preCreate, boolean persist) {
        this.name = name;
        this.entityType = type;
        this.startKey = startKey;
        if (tag != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)baos);
                this.nbtToRead = baos.toByteArray();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.precreateEntity = preCreate ? 1 : 0;
        this.persistEntity = persist ? 1 : 0;
    }

    public int getLength() {
        int l = 0;
        for (Map.Entry<Integer, ArrayList<ActionComponent>> entry : this.actionComponents.entrySet()) {
            if (l >= entry.getKey()) continue;
            l = entry.getKey();
        }
        for (Map.Entry<Integer, Object> entry : this.posComponents.entrySet()) {
            if (l >= entry.getKey()) continue;
            l = entry.getKey();
        }
        for (Map.Entry<Integer, Object> entry : this.lookComponents.entrySet()) {
            if (l >= entry.getKey()) continue;
            l = entry.getKey();
        }
        return l;
    }

    public void doAction(Scene scene, int time) {
        if (this.state != null && this.state.ent != null) {
            LimbComponent comp1;
            LimbComponent comp;
            ArrayList<ActionComponent> act = this.actionComponents.get(time);
            if (act != null) {
                for (ActionComponent comp2 : act) {
                    switch (comp2.toggleType) {
                        case 1: {
                            boolean bl = this.state.useItem = !this.state.useItem;
                            if (!(this.state.ent instanceof EntityPlayer)) break;
                            EntityPlayer player = (EntityPlayer)this.state.ent;
                            if (this.state.useItem && this.state.ent.func_70694_bm() != null) {
                                player.func_71008_a(this.state.ent.func_70694_bm(), this.state.ent.func_70694_bm().func_77988_m());
                                break;
                            }
                            player.func_71034_by();
                            break;
                        }
                        case 2: {
                            this.state.sprinting = !this.state.sprinting;
                            this.state.ent.func_70031_b(this.state.sprinting);
                            break;
                        }
                        case 3: {
                            this.state.sneaking = !this.state.sneaking;
                            this.state.ent.func_70095_a(this.state.sneaking);
                            break;
                        }
                        case 4: {
                            this.state.ent.func_71038_i();
                            MovingObjectPosition mop = EntityHelperBase.getEntityLook(this.state.ent, 4.0);
                            if (mop == null || !mop.field_72313_a.equals((Object)MovingObjectPosition.MovingObjectType.ENTITY)) break;
                            EntityHelperBase.attackEntityWithItem(this.state.ent, mop.field_72308_g);
                            break;
                        }
                        case 5: {
                            this.state.health = (float)comp2.itemAction / 1000.0f;
                            this.state.ent.func_70606_j(this.state.health);
                            this.state.ent.field_70737_aN = comp2.itemNBT[0];
                            this.state.ent.field_70725_aQ = comp2.itemNBT[1];
                            if (this.state.ent.field_70737_aN <= 0) break;
                            if (this.state.ent instanceof EntityPlayer) {
                                this.state.ent.func_85030_a(this.state.ent.field_70725_aQ > 0 ? "game.player.die" : "game.player.hurt", 1.0f, (this.state.ent.func_70681_au().nextFloat() - this.state.ent.func_70681_au().nextFloat()) * 0.2f + 1.0f);
                            }
                            FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148537_a((Packet)new S19PacketEntityStatus((Entity)this.state.ent, (byte)(this.state.ent.field_70725_aQ > 0 ? 3 : 2)), this.state.ent.field_71093_bK);
                            break;
                        }
                        case 6: {
                            boolean bl = this.state.fire = !this.state.fire;
                            if (this.state.fire) {
                                this.state.ent.func_70015_d(24000);
                                this.state.ent.func_70096_w().func_75692_b(0, (Object)((byte)(this.state.ent.func_70096_w().func_75683_a(0) | 1)));
                                break;
                            }
                            this.state.ent.func_70066_B();
                            this.state.ent.func_70096_w().func_75692_b(0, (Object)((byte)(this.state.ent.func_70096_w().func_75683_a(0) & 0xFFFFFFFE)));
                            break;
                        }
                        case 7: {
                            boolean bl = this.state.sleeping = !this.state.sleeping;
                            if (!(this.state.ent instanceof EntityPlayer)) break;
                            EntityPlayer player = (EntityPlayer)this.state.ent;
                            if (this.state.sleeping) {
                                player.func_70105_a(0.2f, 0.2f);
                                player.field_71083_bS = true;
                                player.field_71076_b = 0;
                                player.field_71081_bT = new ChunkCoordinates((int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u - (double)player.field_70129_M), (int)Math.floor(player.field_70161_v));
                                player.field_70181_x = 0.0;
                                player.field_70179_y = 0.0;
                                player.field_70159_w = 0.0;
                            } else {
                                player.func_70105_a(0.6f, 1.8f);
                                player.field_71083_bS = false;
                                player.field_71076_b = 0;
                            }
                            Keygrip.channel.sendToDimension(new PacketToggleSleeping(player.func_145782_y(), this.state.sleeping, comp2.itemAction), player.field_71093_bK);
                            break;
                        }
                        case 0: {
                            if (comp2.itemAction <= 0) break;
                            if (comp2.itemAction <= 5) {
                                if (comp2.itemNBT != null) {
                                    try {
                                        this.state.ent.func_70062_b(comp2.itemAction - 1, ItemStack.func_77949_a((NBTTagCompound)CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(comp2.itemNBT))));
                                    }
                                    catch (IOException player) {}
                                } else {
                                    this.state.ent.func_70062_b(comp2.itemAction - 1, null);
                                }
                                if (!(this.state.ent instanceof EntityPlayer)) break;
                                FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148537_a((Packet)new S04PacketEntityEquipment(this.state.ent.func_145782_y(), comp2.itemAction - 1, this.state.ent.func_71124_b(comp2.itemAction - 1)), ((EntityPlayer)this.state.ent).field_71093_bK);
                                break;
                            }
                            if (comp2.itemAction != 6 || comp2.itemNBT == null) break;
                            ItemStack stack = null;
                            try {
                                stack = ItemStack.func_77949_a((NBTTagCompound)CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(comp2.itemNBT)));
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (stack == null) break;
                            double d0 = this.state.ent.field_70163_u - (double)0.3f + (double)this.state.ent.func_70047_e();
                            EntityItem entityitem = new EntityItem(this.state.ent.field_70170_p, this.state.ent.field_70165_t, d0, this.state.ent.field_70161_v, stack);
                            entityitem.field_145804_b = 40;
                            entityitem.field_145801_f = this.state.ent.func_70005_c_();
                            float f = 0.3f;
                            entityitem.field_70159_w = -MathHelper.func_76126_a((float)(this.state.ent.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.state.ent.field_70125_A / 180.0f * (float)Math.PI)) * f;
                            entityitem.field_70179_y = MathHelper.func_76134_b((float)(this.state.ent.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.state.ent.field_70125_A / 180.0f * (float)Math.PI)) * f;
                            entityitem.field_70181_x = -MathHelper.func_76126_a((float)(this.state.ent.field_70125_A / 180.0f * (float)Math.PI)) * f + 0.1f;
                            float f1 = this.state.ent.func_70681_au().nextFloat() * (float)Math.PI * 2.0f;
                            f = 0.02f * this.state.ent.func_70681_au().nextFloat();
                            entityitem.field_70159_w += Math.cos(f1) * (double)f;
                            entityitem.field_70181_x += (double)((this.state.ent.func_70681_au().nextFloat() - this.state.ent.func_70681_au().nextFloat()) * 0.1f);
                            entityitem.field_70179_y += Math.sin(f1) * (double)f;
                            this.state.ent.field_70170_p.func_72838_d((Entity)entityitem);
                            this.state.additionalEnts.add((Entity)entityitem);
                        }
                    }
                }
            }
            if ((comp = this.lookComponents.get(time)) != null) {
                this.state.rot[0] = (double)comp.actionChange[0] / 1000.0;
                this.state.rot[1] = (double)comp.actionChange[1] / 1000.0;
            }
            if ((comp1 = this.posComponents.get(time)) != null) {
                for (int i = 0; i < 3; ++i) {
                    this.state.pos[i] = (double)(comp1.actionChange[i] + (this.offsetPos[i] + scene.startPos[i])) / 1000.0;
                }
            }
            this.state.ent.field_70179_y = 0.0;
            this.state.ent.field_70181_x = 0.0;
            this.state.ent.field_70159_w = 0.0;
            this.state.ent.field_70181_x = (this.state.pos[1] - this.state.ent.field_70163_u) * (double)0.8f;
            this.state.ent.func_70107_b(this.state.pos[0], this.state.pos[1], this.state.pos[2]);
            this.state.ent.field_70759_as = this.state.ent.field_70177_z = (float)this.state.rot[0];
            this.state.ent.field_70125_A = (float)this.state.rot[1];
            if (this.state.ent instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)this.state.ent;
                if (player.func_110143_aJ() > 0.0f) {
                    AxisAlignedBB axisalignedbb = null;
                    axisalignedbb = player.field_70154_o != null && !player.field_70154_o.field_70128_L ? player.field_70121_D.func_111270_a(player.field_70154_o.field_70121_D).func_72314_b(1.0, 0.0, 1.0) : player.field_70121_D.func_72314_b(1.0, 0.5, 1.0);
                    List list = player.field_70170_p.func_72839_b((Entity)player, axisalignedbb);
                    for (int i = 0; i < list.size(); ++i) {
                        Entity entity = (Entity)list.get(i);
                        if (entity.field_70128_L) continue;
                        entity.func_70100_b_(player);
                    }
                }
                if (this.state.useItem && player.field_71074_e != null) {
                    ItemStack itemstack = player.field_71071_by.func_70448_g();
                    if (itemstack == player.field_71074_e) {
                        player.field_71072_f = ForgeEventFactory.onItemUseTick((EntityPlayer)player, (ItemStack)player.field_71074_e, (int)player.field_71072_f);
                        if (player.field_71072_f <= 0) {
                            player.func_71036_o();
                        } else {
                            player.field_71074_e.func_77973_b().onUsingTick(player.field_71074_e, player, player.field_71072_f);
                            if (player.field_71072_f <= 25 && player.field_71072_f % 4 == 0) {
                                player.func_71010_c(itemstack, 5);
                            }
                            if (--player.field_71072_f == 0 && !player.field_70170_p.field_72995_K) {
                                player.func_71036_o();
                            }
                        }
                    } else {
                        player.func_71041_bz();
                    }
                }
            }
        }
    }

    public boolean createState(WorldServer world, double x, double y, double z) {
        if (this.state == null || this.state.ent == null) {
            try {
                FakePlayer playerDummy = new FakePlayer(world, EntityHelperBase.getSimpleGameProfileFromName("ForgeDev"));
                NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(this.nbtToRead));
                playerDummy.func_70020_e(tag);
                playerDummy.func_70012_b(x, y, z, playerDummy.field_70177_z, playerDummy.field_70125_A);
                playerDummy.func_70109_d(tag);
                this.state = new EntityState((EntityPlayer)playerDummy);
                if (this.entityType.startsWith("player::")) {
                    this.state.ent = new FakePlayer(world, EntityHelperBase.getFullGameProfileFromName(this.entityType.substring("player::".length())));
                    this.state.ent.func_70020_e(tag);
                    new FakeNetHandlerPlayServer(FMLCommonHandler.instance().getMinecraftServerInstance(), new NetworkManager(false), (EntityPlayerMP)((FakePlayer)this.state.ent));
                    FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_148540_a((Packet)new S38PacketPlayerListItem(this.state.ent.func_70005_c_(), true, 1000));
                } else {
                    this.state.ent = (EntityLivingBase)Class.forName(this.entityType).getConstructor(World.class).newInstance(world);
                    this.state.ent.func_70031_b(playerDummy.func_70051_ag());
                    this.state.ent.func_70095_a(playerDummy.func_70093_af());
                    for (int i = 0; i < this.state.ent.func_70035_c().length; ++i) {
                        this.state.ent.func_70062_b(i, playerDummy.func_71124_b(i));
                    }
                }
                if (this.state.ent instanceof EntityLiving) {
                    ((EntityLiving)this.state.ent).func_94061_f(false);
                    ((EntityLiving)this.state.ent).field_70714_bg.field_75782_a.clear();
                    ((EntityLiving)this.state.ent).field_70715_bh.field_75782_a.clear();
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof Action) {
            Action comp = (Action)arg0;
            return Integer.valueOf(this.startKey).compareTo(comp.startKey);
        }
        return 0;
    }

    public static Action openAction(File file) {
        try {
            byte[] data = new byte[(int)file.length()];
            FileInputStream stream = new FileInputStream(file);
            stream.read(data);
            stream.close();
            Action scene = (Action)new Gson().fromJson(IOUtil.decompress(data), Action.class);
            return scene;
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
            return null;
        }
    }
}

