/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.modules;

import info.ata4.minecraft.minema.client.config.MinemaConfig;
import info.ata4.minecraft.minema.client.modules.CaptureModule;
import info.ata4.minecraft.minema.client.modules.CaptureSession;
import info.ata4.minecraft.minema.client.util.CaptureTime;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CaptureOverlay
extends CaptureModule {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private final CaptureSession session;

    public CaptureOverlay(MinemaConfig cfg, CaptureSession session) {
        super(cfg);
        this.session = session;
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text evt) {
        ArrayList left = evt.left;
        if (CaptureOverlay.MC.field_71474_y.field_74330_P) {
            left.add(null);
        }
        CaptureTime time = this.session.getCaptureTime();
        String frame = String.valueOf(time.getNumFrames());
        left.add("Frame: " + frame);
        String fps = Minecraft.func_175610_ah() + " fps";
        left.add("Rate: " + fps);
        String avg = (int)time.getAverageFPS() + " fps";
        left.add("Avg.: " + avg);
        String delay = CaptureTime.getTimeUnit(time.getPreviousCaptureTime());
        left.add("Delay: " + delay);
        left.add("Time R: " + time.getRealTimeString());
        left.add("Time V: " + time.getVideoTimeString());
    }

    @Override
    protected void doEnable() throws Exception {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    protected void doDisable() throws Exception {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }
}

