/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.modules;

import info.ata4.minecraft.minema.client.capture.FramebufferCapturer;
import info.ata4.minecraft.minema.client.config.MinemaConfig;
import info.ata4.minecraft.minema.client.event.CapturePausedEvent;
import info.ata4.minecraft.minema.client.event.CaptureResumedEvent;
import info.ata4.minecraft.minema.client.event.FrameCaptureEvent;
import info.ata4.minecraft.minema.client.event.FramePreCaptureEvent;
import info.ata4.minecraft.minema.client.modules.CaptureModule;
import info.ata4.minecraft.minema.client.modules.CaptureOverlay;
import info.ata4.minecraft.minema.client.modules.CaptureStream;
import info.ata4.minecraft.minema.client.modules.ChunkPreloader;
import info.ata4.minecraft.minema.client.modules.DisplaySizeModifier;
import info.ata4.minecraft.minema.client.modules.EffectRendererModifier;
import info.ata4.minecraft.minema.client.modules.FrameExporter;
import info.ata4.minecraft.minema.client.modules.GameSettingsModifier;
import info.ata4.minecraft.minema.client.modules.ImageFrameExporter;
import info.ata4.minecraft.minema.client.modules.PipeFrameExporter;
import info.ata4.minecraft.minema.client.modules.TickSynchronizer;
import info.ata4.minecraft.minema.client.modules.TimerModifier;
import info.ata4.minecraft.minema.client.util.CaptureTime;
import info.ata4.minecraft.minema.client.util.ChatUtils;
import info.ata4.minecraft.minema.util.reflection.PrivateFields;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.stream.IStream;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CaptureSession
extends CaptureModule {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final Logger L = LogManager.getLogger();
    private final List<CaptureModule> modules = new ArrayList<CaptureModule>();
    private final EventBus eventBus = new EventBus();
    private CaptureTime time;
    private FramebufferCapturer fbc;
    private IStream defaultStream;
    private File movieDir;
    private boolean paused;

    public CaptureSession(MinemaConfig cfg) {
        super(cfg);
    }

    @Override
    protected void doEnable() {
        File captureDir = new File((String)this.cfg.capturePath.get());
        String movieName = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        this.movieDir = new File(captureDir, movieName);
        if (!this.movieDir.exists()) {
            this.movieDir.mkdirs();
        }
        this.cfg.setMovieDir(this.movieDir);
        this.modules.add(new GameSettingsModifier(this.cfg));
        if (this.cfg.isSyncEngine()) {
            this.modules.add(new TimerModifier(this.cfg));
            this.modules.add(new TickSynchronizer(this.cfg));
        }
        if (this.cfg.useFrameSize()) {
            this.modules.add(new DisplaySizeModifier(this.cfg));
        }
        this.modules.add(new EffectRendererModifier(this.cfg));
        FrameExporter exporter = (Boolean)this.cfg.useVideoEncoder.get() != false ? new PipeFrameExporter(this.cfg) : new ImageFrameExporter(this.cfg);
        this.modules.add(exporter);
        if (((Boolean)this.cfg.preloadChunks.get()).booleanValue()) {
            this.modules.add(new ChunkPreloader(this.cfg));
        }
        if (((Boolean)this.cfg.showOverlay.get()).booleanValue()) {
            this.modules.add(new CaptureOverlay(this.cfg, this));
        }
        for (CaptureModule module : this.modules) {
            module.enable();
            this.eventBus.register((Object)module);
        }
        this.time = new CaptureTime(this.cfg);
        this.fbc = new FramebufferCapturer();
        exporter.configureCapturer(this.fbc);
        this.defaultStream = MC.func_152346_Z();
        this.setStream((IStream)new CaptureStream(this));
        this.playSound();
    }

    @Override
    protected void doDisable() {
        for (CaptureModule module : this.modules) {
            try {
                if (module.isEnabled()) {
                    module.disable();
                }
            }
            catch (Throwable t) {
                L.error("Can't disable module {}", new Object[]{module.getName(), t});
            }
            try {
                this.eventBus.unregister((Object)module);
            }
            catch (NullPointerException nullPointerException) {}
        }
        this.modules.clear();
        if (this.movieDir != null && this.movieDir.exists() && this.movieDir.list().length == 0) {
            this.movieDir.delete();
        }
        this.cfg.setMovieDir(null);
        if (this.defaultStream != null) {
            this.setStream(this.defaultStream);
            this.defaultStream = null;
        }
    }

    @Override
    protected void handleError(Throwable t) {
        ChatUtils.print("minema.error.label", EnumChatFormatting.RED, new Object[0]);
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        do {
            throwables.add(t);
        } while ((t = t.getCause()) != null);
        for (Throwable throwable : throwables) {
            Throwable cause;
            String message = throwable.getMessage();
            if (message == null || (cause = throwable.getCause()) != null && message.equals(cause.toString())) continue;
            ChatUtils.print(message, EnumChatFormatting.RED, new Object[0]);
        }
    }

    public void captureFrame() {
        if (!this.isEnabled() || this.isPaused()) {
            return;
        }
        if (!this.cfg.isSyncEngine() && !this.time.isNextFrame()) {
            return;
        }
        try {
            if (this.eventBus.post((Event)new FramePreCaptureEvent(this.time.getNumFrames(), this.fbc.getCaptureDimension()))) {
                throw new RuntimeException("Frame capturing cancelled at frame " + this.time.getNumFrames());
            }
            this.fbc.capture();
            if (this.eventBus.post((Event)new FrameCaptureEvent(this.time.getNumFrames(), this.fbc.getCaptureDimension(), this.fbc.getByteBuffer()))) {
                throw new RuntimeException("Frame capturing cancelled at frame " + this.time.getNumFrames());
            }
            this.time.nextFrame();
            if (this.time.isAtFrameLimit()) {
                this.disable();
            }
        }
        catch (Throwable t) {
            L.error("Frame capturing error", t);
            this.handleError(t);
            this.disable();
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        Event evt = null;
        if (paused && !this.paused) {
            evt = new CapturePausedEvent();
        } else if (!paused && this.paused) {
            evt = new CaptureResumedEvent();
        }
        this.paused = paused;
        if (evt != null) {
            this.eventBus.post(evt);
        }
    }

    public CaptureTime getCaptureTime() {
        return this.time;
    }

    private void setStream(IStream stream) {
        try {
            ReflectionHelper.setPrivateValue(Minecraft.class, (Object)MC, (Object)stream, (String[])PrivateFields.MINECRAFT_STREAM);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't set stream", ex);
        }
    }

    private void playSound() {
        try {
            if (CaptureSession.MC.field_71441_e != null && CaptureSession.MC.field_71439_g != null) {
                CaptureSession.MC.field_71441_e.func_72980_b(CaptureSession.MC.field_71439_g.field_70165_t, CaptureSession.MC.field_71439_g.field_70163_u, CaptureSession.MC.field_71439_g.field_70161_v, "mob.chicken.plop", 1.0f, this.isEnabled() ? 2.0f : 1.0f, false);
            }
        }
        catch (Exception ex) {
            L.warn("Can't play capture sound", (Throwable)ex);
        }
    }
}

