/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.modules;

import info.ata4.minecraft.minema.client.config.MinemaConfig;
import info.ata4.minecraft.minema.client.modules.CaptureModule;
import info.ata4.minecraft.minema.util.reflection.PrivateFields;
import info.ata4.minecraft.minema.util.reflection.PrivateMethods;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.Display;

public class DisplaySizeModifier
extends CaptureModule {
    private static final Logger L = LogManager.getLogger();
    private static final Minecraft MC = Minecraft.func_71410_x();
    private int originalWidth;
    private int originalHeight;

    public DisplaySizeModifier(MinemaConfig cfg) {
        super(cfg);
    }

    @Override
    protected void doEnable() {
        this.originalWidth = Display.getWidth();
        this.originalHeight = Display.getHeight();
        this.resize(this.cfg.getFrameWidth(), this.cfg.getFrameHeight());
        if (OpenGlHelper.func_148822_b()) {
            this.setFramebufferTextureSize(this.originalWidth, this.originalHeight);
        }
    }

    @Override
    protected void doDisable() {
        this.resize(this.originalWidth, this.originalHeight);
    }

    public void resize(int width, int height) {
        try {
            Method resize = ReflectionHelper.findMethod(Minecraft.class, (Object)MC, (String[])PrivateMethods.MINECRAFT_RESIZE, (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
            resize.invoke((Object)MC, width, height);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't resize display", ex);
        }
    }

    public void setFramebufferTextureSize(int width, int height) {
        try {
            Framebuffer fb = MC.func_147110_a();
            ReflectionHelper.setPrivateValue(Framebuffer.class, (Object)fb, (Object)width, (String[])PrivateFields.FRAMEBUFFER_FRAMEBUFFERTEXTUREWIDTH);
            ReflectionHelper.setPrivateValue(Framebuffer.class, (Object)fb, (Object)height, (String[])PrivateFields.FRAMEBUFFER_FRAMEBUFFERTEXTUREHEIGHT);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't set framebuffer texture size", ex);
        }
    }
}

