/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.modules;

import info.ata4.minecraft.minema.client.capture.FramebufferCapturer;
import info.ata4.minecraft.minema.client.config.MinemaConfig;
import info.ata4.minecraft.minema.client.event.FrameCaptureEvent;
import info.ata4.minecraft.minema.client.event.FramePreCaptureEvent;
import info.ata4.minecraft.minema.client.modules.CaptureModule;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FrameExporter
extends CaptureModule {
    private static final Logger L = LogManager.getLogger();
    protected ExecutorService exportService;
    protected Future exportFuture;
    private boolean concurrent = true;

    public FrameExporter(MinemaConfig cfg) {
        super(cfg);
    }

    public void setConcurrent(boolean threaded) {
        if (this.isEnabled()) {
            throw new IllegalStateException("Can't change concurrent setting while module is active!");
        }
        this.concurrent = threaded;
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    @Override
    protected void doEnable() throws Exception {
        if (this.isConcurrent()) {
            this.exportService = Executors.newSingleThreadExecutor();
        }
    }

    @Override
    protected void doDisable() throws Exception {
        if (this.isConcurrent()) {
            this.exportService.shutdown();
            try {
                if (!this.exportService.awaitTermination(3L, TimeUnit.SECONDS)) {
                    L.warn("Frame export service termination timeout");
                    this.exportService.shutdownNow();
                }
            }
            catch (InterruptedException ex) {
                L.warn("Frame export service termination interrupted", (Throwable)ex);
            }
        }
    }

    @SubscribeEvent
    public void onFramePreCapture(FramePreCaptureEvent evt) throws ExecutionException {
        if (!this.isEnabled()) {
            return;
        }
        if (this.isConcurrent() && this.exportFuture != null) {
            try {
                this.exportFuture.get();
            }
            catch (InterruptedException ex) {
                L.warn("Frame export task interrupted", (Throwable)ex);
            }
        }
    }

    @SubscribeEvent
    public void onFrameCapture(final FrameCaptureEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.isConcurrent()) {
            this.exportFuture = this.exportService.submit(new Runnable(){

                @Override
                public void run() {
                    FrameExporter.this.exportFrame(evt);
                }
            });
        } else {
            this.exportFrame(evt);
        }
    }

    private void exportFrame(FrameCaptureEvent evt) {
        try {
            this.doExportFrame(evt);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't export frame " + evt.frameNum, ex);
        }
    }

    protected abstract void doExportFrame(FrameCaptureEvent var1) throws Exception;

    public abstract void configureCapturer(FramebufferCapturer var1);
}

