/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.util.config;

import info.ata4.minecraft.minema.util.config.ConfigValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigContainer {
    private static final Logger L = LogManager.getLogger();
    private final Configuration config;
    private final Map<Pair<String, String>, Pair<ConfigValue, Property>> propMap = new LinkedHashMap<Pair<String, String>, Pair<ConfigValue, Property>>();
    private String langKeyPrefix = "";

    public ConfigContainer(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public String getLangKeyPrefix() {
        return this.langKeyPrefix;
    }

    public void setLangKeyPrefix(String langKeyPrefix) {
        Validate.notNull((Object)langKeyPrefix);
        this.langKeyPrefix = langKeyPrefix;
    }

    public List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        Set names = this.config.getCategoryNames();
        for (String catName : names) {
            if (catName.equals("general")) continue;
            list.add((IConfigElement)new ConfigElement(this.config.getCategory(catName)));
        }
        if (this.config.hasCategory("general")) {
            ConfigCategory catGeneral = this.config.getCategory("general");
            List props = catGeneral.getOrderedValues();
            for (Property prop : props) {
                list.add((IConfigElement)new ConfigElement(prop));
            }
        }
        return list;
    }

    public void load() {
        L.debug("Loading config");
        try {
            this.config.load();
        }
        catch (Exception ex) {
            L.warn("Can't load config", (Throwable)ex);
        }
        LinkedHashMap<Pair<String, String>, Pair<ConfigValue, Property>> propMapCopy = new LinkedHashMap<Pair<String, String>, Pair<ConfigValue, Property>>(this.propMap);
        this.propMap.clear();
        for (Map.Entry propEntry : propMapCopy.entrySet()) {
            String catName = (String)((Pair)propEntry.getKey()).getLeft();
            String propName = (String)((Pair)propEntry.getKey()).getRight();
            ConfigValue configValue = (ConfigValue)((Pair)propEntry.getValue()).getLeft();
            this.register(configValue, propName, catName);
        }
    }

    public void save() {
        L.debug("Saving config");
        try {
            if (this.config.hasChanged()) {
                this.config.save();
            }
        }
        catch (Exception ex) {
            L.warn("Can't save config", (Throwable)ex);
        }
    }

    public void update(boolean export) {
        L.debug("Syncing config");
        for (Pair<ConfigValue, Property> propEntry : this.propMap.values()) {
            ConfigValue configValue = (ConfigValue)propEntry.getLeft();
            Property prop = (Property)propEntry.getRight();
            if (export) {
                configValue.exportProp(prop);
                continue;
            }
            configValue.importProp(prop);
        }
        this.save();
    }

    protected void register(ConfigValue configValue, String propName, String catName) {
        String catLangKey = this.langKeyPrefix + "." + catName;
        String catDesc = WordUtils.wrap((String)I18n.func_135052_a((String)(catLangKey + ".tooltip"), (Object[])new Object[0]), (int)128);
        ConfigCategory cat = this.config.getCategory(catName);
        cat.setLanguageKey(catLangKey);
        cat.setComment(catDesc);
        String propLangKey = this.langKeyPrefix + "." + propName;
        String propDesc = WordUtils.wrap((String)I18n.func_135052_a((String)(propLangKey + ".tooltip"), (Object[])new Object[0]), (int)128);
        String propDefault = String.valueOf(configValue.getDefault());
        Property.Type propType = configValue.getPropType();
        Property prop = this.config.get(catName, propName, propDefault, propDesc, propType);
        prop.setLanguageKey(propLangKey);
        configValue.importProp(prop);
        configValue.exportProp(prop);
        ImmutablePair mapKey = new ImmutablePair((Object)catName, (Object)propName);
        ImmutablePair mapValue = new ImmutablePair((Object)configValue, (Object)prop);
        this.propMap.put((Pair<String, String>)mapKey, (Pair<ConfigValue, Property>)mapValue);
        ArrayList<Object> propertyOrder = new ArrayList<Object>();
        for (Pair<String, String> propEntry : this.propMap.keySet()) {
            if (!((String)propEntry.getLeft()).equals(catName)) continue;
            propertyOrder.add(propEntry.getRight());
        }
        cat.setPropertyOrder(propertyOrder);
        L.debug("Registered prop {}.{} of type {}", new Object[]{catName, propName, propType});
    }
}

