/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.capture;

import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Dimension;

public class FramebufferCapturer {
    private static final int BPP = 3;
    private static final int TYPE = 5121;
    private static final Minecraft MC = Minecraft.func_71410_x();
    private final ByteBuffer bb;
    private final Dimension dim = this.getCurrentDimension();
    private final byte[] line1;
    private final byte[] line2;
    private boolean flipColors = false;
    private boolean flipLines = false;

    public FramebufferCapturer() {
        this.bb = ByteBuffer.allocateDirect(this.dim.getWidth() * this.dim.getHeight() * 3);
        this.line1 = new byte[FramebufferCapturer.MC.field_71443_c * 3];
        this.line2 = new byte[FramebufferCapturer.MC.field_71443_c * 3];
    }

    public void setFlipColors(boolean flipColors) {
        this.flipColors = flipColors;
    }

    public boolean isFlipColors() {
        return this.flipColors;
    }

    public void setFlipLines(boolean flipLines) {
        this.flipLines = flipLines;
    }

    public boolean isFlipLines() {
        return this.flipLines;
    }

    public int getBytesPerPixel() {
        return 3;
    }

    public ByteBuffer getByteBuffer() {
        this.bb.rewind();
        return this.bb.duplicate();
    }

    public Dimension getCaptureDimension() {
        return this.dim;
    }

    private Dimension getCurrentDimension() {
        return new Dimension(FramebufferCapturer.MC.field_71443_c, FramebufferCapturer.MC.field_71440_d);
    }

    public void capture() {
        int format;
        Dimension dim2;
        Dimension dim1 = this.getCurrentDimension();
        if (!dim1.equals((Object)(dim2 = this.getCaptureDimension()))) {
            throw new IllegalStateException(String.format("Display size changed! %dx%d != %dx%d", dim1.getWidth(), dim1.getHeight(), dim2.getWidth(), dim2.getHeight()));
        }
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        int n = format = this.flipColors ? 32992 : 6407;
        if (OpenGlHelper.func_148822_b()) {
            Framebuffer fb = MC.func_147110_a();
            GL11.glBindTexture((int)3553, (int)fb.field_147617_g);
            GL11.glGetTexImage((int)3553, (int)0, (int)format, (int)5121, (ByteBuffer)this.bb);
        } else {
            GL11.glReadPixels((int)0, (int)0, (int)FramebufferCapturer.MC.field_71443_c, (int)FramebufferCapturer.MC.field_71440_d, (int)format, (int)5121, (ByteBuffer)this.bb);
        }
        if (!this.flipLines) {
            return;
        }
        for (int i = 0; i < FramebufferCapturer.MC.field_71440_d / 2; ++i) {
            int ofs1 = i * FramebufferCapturer.MC.field_71443_c * 3;
            int ofs2 = (FramebufferCapturer.MC.field_71440_d - i - 1) * FramebufferCapturer.MC.field_71443_c * 3;
            this.bb.position(ofs1);
            this.bb.get(this.line1);
            this.bb.position(ofs2);
            this.bb.get(this.line2);
            this.bb.position(ofs2);
            this.bb.put(this.line1);
            this.bb.position(ofs1);
            this.bb.put(this.line2);
        }
    }
}

