/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.config;

import info.ata4.minecraft.minema.client.config.SnapResolution;
import info.ata4.minecraft.minema.util.config.ConfigBoolean;
import info.ata4.minecraft.minema.util.config.ConfigContainer;
import info.ata4.minecraft.minema.util.config.ConfigDouble;
import info.ata4.minecraft.minema.util.config.ConfigEnum;
import info.ata4.minecraft.minema.util.config.ConfigInteger;
import info.ata4.minecraft.minema.util.config.ConfigString;
import info.ata4.minecraft.minema.util.config.ConfigStringEnum;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.opengl.Display;

public class MinemaConfig
extends ConfigContainer {
    private static final int MAX_TEXTURE_SIZE = Minecraft.func_71369_N();
    public static final String CATEGORY_ENCODING = "encoding";
    public static final String CATEGORY_CAPTURING = "capturing";
    public static final String CATEGORY_ENGINE = "engine";
    public final ConfigStringEnum imageFormat = new ConfigStringEnum("tga", MinemaConfig.getImageFormats());
    public final ConfigBoolean useVideoEncoder = new ConfigBoolean(false);
    public final ConfigString videoEncoderPath = new ConfigString("");
    public final ConfigString videoEncoderParams = new ConfigString("");
    public final ConfigEnum<SnapResolution> snapResolution = new ConfigEnum<SnapResolution>(SnapResolution.MOD2);
    public final ConfigInteger frameWidth = new ConfigInteger(0, 0, MAX_TEXTURE_SIZE);
    public final ConfigInteger frameHeight = new ConfigInteger(0, 0, MAX_TEXTURE_SIZE);
    public final ConfigDouble frameRate = new ConfigDouble(30.0, 0.01, 1000.0);
    public final ConfigInteger frameLimit = new ConfigInteger(-1, -1);
    public final ConfigString capturePath = new ConfigString("movies");
    public final ConfigBoolean showOverlay = new ConfigBoolean(false);
    public final ConfigDouble engineSpeed = new ConfigDouble(1.0, 0.01);
    public final ConfigInteger particleLimit = new ConfigInteger(64000, -1);
    public final ConfigBoolean syncEngine = new ConfigBoolean(true);
    public final ConfigBoolean preloadChunks = new ConfigBoolean(false);
    private File movieDir;

    private static Set<String> getImageFormats() {
        HashSet<String> formats = new HashSet<String>();
        for (String formatName : ImageIO.getWriterFormatNames()) {
            formats.add(formatName.toLowerCase());
        }
        formats.add("tga");
        formats.remove("jpeg");
        return formats;
    }

    public MinemaConfig(Configuration config) {
        super(config);
        this.setLangKeyPrefix("minema.config");
        this.register(this.imageFormat, "imageFormat", CATEGORY_ENCODING);
        this.register(this.useVideoEncoder, "useVideoEncoder", CATEGORY_ENCODING);
        this.register(this.videoEncoderPath, "videoEncoderPath", CATEGORY_ENCODING);
        this.register(this.videoEncoderParams, "videoEncoderParams", CATEGORY_ENCODING);
        this.register(this.snapResolution, "snapResolution", CATEGORY_ENCODING);
        this.register(this.frameWidth, "frameWidth", CATEGORY_CAPTURING);
        this.register(this.frameHeight, "frameHeight", CATEGORY_CAPTURING);
        this.register(this.frameRate, "frameRate", CATEGORY_CAPTURING);
        this.register(this.frameLimit, "frameLimit", CATEGORY_CAPTURING);
        this.register(this.capturePath, "capturePath", CATEGORY_CAPTURING);
        this.register(this.showOverlay, "showOverlay", CATEGORY_CAPTURING);
        this.register(this.engineSpeed, "engineSpeed", CATEGORY_ENGINE);
        this.register(this.particleLimit, "particleLimit", CATEGORY_ENGINE);
        this.register(this.syncEngine, "syncEngine", CATEGORY_ENGINE);
        this.update(true);
    }

    public int getFrameWidth() {
        int width = (Integer)this.frameWidth.get() == 0 ? Display.getWidth() : (Integer)this.frameWidth.get();
        if (((Boolean)this.useVideoEncoder.get()).booleanValue()) {
            width = ((SnapResolution)((Object)this.snapResolution.get())).snap(width);
        }
        return width;
    }

    public int getFrameHeight() {
        int height = (Integer)this.frameHeight.get() == 0 ? Display.getHeight() : (Integer)this.frameHeight.get();
        if (((Boolean)this.useVideoEncoder.get()).booleanValue()) {
            height = ((SnapResolution)((Object)this.snapResolution.get())).snap(height);
        }
        return height;
    }

    public boolean useFrameSize() {
        return this.getFrameWidth() != Display.getWidth() || this.getFrameHeight() != Display.getHeight();
    }

    public boolean isSyncEngine() {
        return Minecraft.func_71410_x().func_71356_B() && (Boolean)this.syncEngine.get() != false;
    }

    public File getMovieDir() {
        return this.movieDir;
    }

    public void setMovieDir(File movieDir) {
        this.movieDir = movieDir;
    }
}

