/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.engine;

import info.ata4.minecraft.minema.util.reflection.PrivateFields;
import java.util.List;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtendedEffectRenderer
extends EffectRenderer {
    private static final Logger L = LogManager.getLogger();
    private List<EntityFX>[][] fxLayers;
    private int particleLimit = 4000;

    public ExtendedEffectRenderer(World world, TextureManager textureManager) {
        super(world, textureManager);
        try {
            this.fxLayers = (List[][])ReflectionHelper.getPrivateValue(EffectRenderer.class, (Object)((Object)this), (String[])PrivateFields.EFFECTRENDERER_FXLAYERS);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't get FX layers array", ex);
        }
    }

    public void func_78873_a(EntityFX fx) {
        if (fx == null) {
            return;
        }
        if (this.particleLimit == 0) {
            return;
        }
        int i = fx.func_70537_b();
        int j = fx.func_174838_j() != 1.0f ? 0 : 1;
        List<EntityFX> fxLayer = this.fxLayers[i][j];
        if (this.particleLimit > 0 && fxLayer.size() >= this.particleLimit) {
            fxLayer.remove(0);
        }
        fxLayer.add(fx);
    }

    public int getParticleLimit() {
        return this.particleLimit;
    }

    public void setParticleLimit(int particleLimit) {
        this.particleLimit = particleLimit;
    }
}

