/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.modules;

import info.ata4.minecraft.minema.client.config.MinemaConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CaptureModule {
    private static final Logger L = LogManager.getLogger();
    protected final MinemaConfig cfg;
    private boolean enabled;

    public CaptureModule(MinemaConfig cfg) {
        this.cfg = cfg;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public final synchronized void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        L.info("Enabling " + this.getName());
        try {
            this.doEnable();
        }
        catch (Throwable t) {
            L.error("Can't enable " + this.getName(), t);
            this.handleError(t);
            this.disable();
        }
    }

    public final synchronized void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        L.info("Disabling " + this.getName());
        try {
            this.doDisable();
        }
        catch (Throwable t) {
            L.error("Can't disable " + this.getName(), t);
            this.handleError(t);
        }
    }

    protected void handleError(Throwable t) {
        throw new RuntimeException(t);
    }

    protected abstract void doEnable() throws Exception;

    protected abstract void doDisable() throws Exception;
}

