/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.modules;

import info.ata4.minecraft.minema.client.config.MinemaConfig;
import info.ata4.minecraft.minema.client.modules.CaptureModule;
import info.ata4.minecraft.minema.util.reflection.PrivateFields;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ChunkPreloader
extends CaptureModule {
    private static final Minecraft MC = Minecraft.func_71410_x();
    private Set<RenderChunk> chunksToUpdate;
    private ChunkRenderDispatcher renderDispatcher;

    public ChunkPreloader(MinemaConfig cfg) {
        super(cfg);
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.chunksToUpdate == null || this.renderDispatcher == null) {
            return;
        }
        Iterator<RenderChunk> iterator = this.chunksToUpdate.iterator();
        while (iterator.hasNext()) {
            RenderChunk renderChunk = iterator.next();
            this.renderDispatcher.func_178505_b(renderChunk);
            renderChunk.func_178575_a(false);
            iterator.remove();
        }
    }

    @Override
    protected void doEnable() throws Exception {
        try {
            this.chunksToUpdate = (Set)ReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)ChunkPreloader.MC.field_71438_f, (String[])PrivateFields.RENDERGLOBAL_CHUNKSTOUPDATE);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't get chunksToUpdate field", ex);
        }
        try {
            this.renderDispatcher = (ChunkRenderDispatcher)ReflectionHelper.getPrivateValue(RenderGlobal.class, (Object)ChunkPreloader.MC.field_71438_f, (String[])PrivateFields.RENDERGLOBAL_RENDERDISPATCHER);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't get renderDispatcher field", ex);
        }
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    protected void doDisable() throws Exception {
        FMLCommonHandler.instance().bus().unregister((Object)this);
    }
}

