/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.modules;

import info.ata4.minecraft.minema.client.config.MinemaConfig;
import info.ata4.minecraft.minema.client.engine.ExtendedEffectRenderer;
import info.ata4.minecraft.minema.client.modules.CaptureModule;
import info.ata4.minecraft.minema.util.reflection.PrivateFields;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EffectRendererModifier
extends CaptureModule {
    private static final Logger L = LogManager.getLogger();
    private static final Minecraft MC = Minecraft.func_71410_x();

    public EffectRendererModifier(MinemaConfig cfg) {
        super(cfg);
    }

    @Override
    protected void doEnable() throws Exception {
        EffectRenderer effectRenderer = this.getEffectRenderer();
        if (effectRenderer == null) {
            return;
        }
        if (effectRenderer instanceof ExtendedEffectRenderer) {
            L.warn("Effect renderer is already modified!");
            return;
        }
        effectRenderer.func_78870_a((World)EffectRendererModifier.MC.field_71441_e);
        ExtendedEffectRenderer extEffectRenderer = new ExtendedEffectRenderer((World)EffectRendererModifier.MC.field_71441_e, EffectRendererModifier.MC.field_71446_o);
        extEffectRenderer.setParticleLimit((Integer)this.cfg.particleLimit.get());
        this.setEffectRenderer(extEffectRenderer);
    }

    @Override
    protected void doDisable() throws Exception {
        EffectRenderer effectRenderer = this.getEffectRenderer();
        if (effectRenderer == null) {
            return;
        }
        if (!(effectRenderer instanceof ExtendedEffectRenderer)) {
            L.warn("Effect renderer is already restored!");
            return;
        }
        effectRenderer.func_78870_a((World)EffectRendererModifier.MC.field_71441_e);
        EffectRenderer extEffectRenderer = new EffectRenderer((World)EffectRendererModifier.MC.field_71441_e, EffectRendererModifier.MC.field_71446_o);
        this.setEffectRenderer(extEffectRenderer);
    }

    private EffectRenderer getEffectRenderer() {
        try {
            return (EffectRenderer)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)MC, (String[])PrivateFields.MINECRAFT_EFFECTRENDERER);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't get effect renderer", ex);
        }
    }

    private void setEffectRenderer(EffectRenderer effectRenderer) {
        try {
            ReflectionHelper.setPrivateValue(Minecraft.class, (Object)MC, (Object)effectRenderer, (String[])PrivateFields.MINECRAFT_EFFECTRENDERER);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't set effect renderer", ex);
        }
    }
}

