/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.modules;

import info.ata4.minecraft.minema.client.capture.FramebufferCapturer;
import info.ata4.minecraft.minema.client.config.MinemaConfig;
import info.ata4.minecraft.minema.client.event.FrameCaptureEvent;
import info.ata4.minecraft.minema.client.modules.FrameExporter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class ImageFrameExporter
extends FrameExporter {
    public ImageFrameExporter(MinemaConfig cfg) {
        super(cfg);
    }

    @Override
    public void configureCapturer(FramebufferCapturer fbc) {
        if (((String)this.cfg.imageFormat.get()).equals("tga")) {
            fbc.setFlipColors(true);
            fbc.setFlipLines(false);
        } else {
            fbc.setFlipColors(false);
            fbc.setFlipLines(true);
        }
    }

    @Override
    protected void doExportFrame(FrameCaptureEvent evt) throws IOException {
        String format = (String)this.cfg.imageFormat.get();
        String fileName = String.format("%06d.%s", evt.frameNum, format);
        File file = new File(this.cfg.getMovieDir(), fileName);
        this.writeImage(file, evt.frameBuffer, evt.frameDim.getWidth(), evt.frameDim.getHeight(), format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImage(File file, ByteBuffer bb, int width, int height, String format) throws IOException {
        block5: {
            block4: {
                if (!format.equals("tga")) break block4;
                byte[] tgaHeader = new byte[18];
                tgaHeader[2] = 2;
                tgaHeader[12] = (byte)(width % 256);
                tgaHeader[13] = (byte)(width / 256);
                tgaHeader[14] = (byte)(height % 256);
                tgaHeader[15] = (byte)(height / 256);
                tgaHeader[16] = 24;
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(file);
                    FileChannel channel = os.getChannel();
                    channel.write(ByteBuffer.wrap(tgaHeader));
                    channel.write(bb);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)os);
                break block5;
            }
            int[] imageData = new int[width * height];
            byte[] pixel = new byte[3];
            int pixels = bb.capacity() / pixel.length;
            for (int i = 0; i < pixels; ++i) {
                bb.get(pixel);
                imageData[i] = (pixel[0] << 16) + (pixel[1] << 8) + pixel[2];
            }
            BufferedImage image = new BufferedImage(width, height, 1);
            image.setRGB(0, 0, width, height, imageData, 0, width);
            if (!ImageIO.write((RenderedImage)image, format, file)) {
                throw new RuntimeException("No appropriate image writer found for format " + format);
            }
        }
    }
}

