/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.modules;

import info.ata4.minecraft.minema.client.capture.FramebufferCapturer;
import info.ata4.minecraft.minema.client.config.MinemaConfig;
import info.ata4.minecraft.minema.client.event.FrameCaptureEvent;
import info.ata4.minecraft.minema.client.modules.FrameExporter;
import info.ata4.minecraft.minema.io.StreamPipe;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PipeFrameExporter
extends FrameExporter {
    private static final Logger L = LogManager.getLogger();
    private Process proc;
    private WritableByteChannel pipe;
    private OutputStream log;

    public PipeFrameExporter(MinemaConfig cfg) {
        super(cfg);
    }

    @Override
    protected void doEnable() throws Exception {
        super.doEnable();
        String params = (String)this.cfg.videoEncoderParams.get();
        params = params.replace("%WIDTH%", String.valueOf(this.cfg.getFrameWidth()));
        params = params.replace("%HEIGHT%", String.valueOf(this.cfg.getFrameHeight()));
        params = params.replace("%FPS%", String.valueOf(this.cfg.frameRate.get()));
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add((String)this.cfg.videoEncoderPath.get());
        cmds.addAll(Arrays.asList(StringUtils.split((String)params, (char)' ')));
        ProcessBuilder pb = new ProcessBuilder(cmds);
        pb.directory(this.cfg.getMovieDir());
        this.proc = pb.start();
        this.log = FileUtils.openOutputStream((File)new File(this.cfg.getMovieDir(), "encoder.log"));
        new StreamPipe(this.proc.getInputStream(), this.log).start();
        new StreamPipe(this.proc.getErrorStream(), this.log).start();
        this.pipe = Channels.newChannel(this.proc.getOutputStream());
    }

    @Override
    protected void doDisable() throws Exception {
        super.doDisable();
        IOUtils.closeQuietly((Closeable)this.pipe);
        IOUtils.closeQuietly((OutputStream)this.log);
        if (this.proc != null) {
            try {
                this.proc.waitFor();
            }
            catch (InterruptedException ex) {
                L.warn("Pipe program termination interrupted", (Throwable)ex);
            }
            this.proc.destroy();
        }
    }

    @Override
    public void configureCapturer(FramebufferCapturer fbc) {
        fbc.setFlipColors(false);
        fbc.setFlipLines(true);
    }

    @Override
    protected void doExportFrame(FrameCaptureEvent evt) throws Exception {
        if (this.pipe.isOpen()) {
            this.pipe.write(evt.frameBuffer);
        }
    }
}

