/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.modules;

import info.ata4.minecraft.minema.client.config.MinemaConfig;
import info.ata4.minecraft.minema.client.modules.CaptureModule;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TickSynchronizer
extends CaptureModule {
    private static final Logger L = LogManager.getLogger();
    private static final Minecraft MC = Minecraft.func_71410_x();
    private static final long WAIT_INTERVAL = TimeUnit.SECONDS.toNanos(1L);
    private final AtomicBoolean serverReady = new AtomicBoolean();
    private final AtomicBoolean clientReady = new AtomicBoolean();
    private final AtomicInteger serverTick = new AtomicInteger();
    private final AtomicInteger clientTick = new AtomicInteger();
    private final Lock lock = new ReentrantLock();
    private final Condition serverAhead = this.lock.newCondition();
    private final Condition clientAhead = this.lock.newCondition();

    public TickSynchronizer(MinemaConfig cfg) {
        super(cfg);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent evt) {
        if (!this.isEnabled() || evt.phase != TickEvent.Phase.START) {
            return;
        }
        if (!this.clientReady.get()) {
            L.info("Client tick sync ready");
            this.clientReady.set(true);
            this.clientTick.set(0);
        }
        if (!this.serverReady.get()) {
            return;
        }
        if (MC.func_147113_T()) {
            return;
        }
        this.waitFor(evt.side, this.clientTick, this.serverTick, this.clientAhead, this.serverAhead);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent evt) {
        if (!this.isEnabled() || evt.phase != TickEvent.Phase.START) {
            return;
        }
        if (!this.serverReady.get()) {
            L.info("Server tick sync ready");
            this.serverReady.set(true);
            this.serverTick.set(0);
        }
        if (!this.clientReady.get()) {
            return;
        }
        this.waitFor(evt.side, this.serverTick, this.clientTick, this.serverAhead, this.clientAhead);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(Side side, AtomicInteger actual, AtomicInteger target, Condition waitCon, Condition signalCon) {
        this.lock.lock();
        try {
            while (target.get() < actual.get()) {
                if (L.isDebugEnabled()) {
                    int behind = actual.get() - target.get();
                    Side otherSide = side == Side.CLIENT ? Side.SERVER : Side.CLIENT;
                    L.debug("{} waiting, {} {} ticks behind", new Object[]{side, otherSide, behind});
                }
                waitCon.awaitNanos(WAIT_INTERVAL);
                this.checkServer();
                if (this.isEnabled() && this.serverReady.get() && this.clientReady.get()) continue;
                return;
            }
            actual.addAndGet(1);
            if (L.isDebugEnabled()) {
                L.debug("{} tick: {}", new Object[]{side, actual.get()});
            }
            signalCon.signal();
        }
        catch (InterruptedException ex) {
            this.disable();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkServer() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null || !server.func_71278_l() || server.func_71241_aa()) {
            this.serverReady.set(false);
        }
    }

    @Override
    protected void doEnable() throws Exception {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    protected void doDisable() throws Exception {
        this.clientReady.set(false);
        this.serverReady.set(false);
        FMLCommonHandler.instance().bus().unregister((Object)this);
    }
}

