/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.modules;

import info.ata4.minecraft.minema.client.config.MinemaConfig;
import info.ata4.minecraft.minema.client.engine.FixedTimer;
import info.ata4.minecraft.minema.client.modules.CaptureModule;
import info.ata4.minecraft.minema.util.reflection.PrivateFields;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Timer;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimerModifier
extends CaptureModule {
    private static final Logger L = LogManager.getLogger();
    private static final Minecraft MC = Minecraft.func_71410_x();
    private float defaultTps;

    public TimerModifier(MinemaConfig cfg) {
        super(cfg);
    }

    @Override
    protected void doEnable() {
        Timer defaultTimer = this.getTimer();
        if (defaultTimer instanceof FixedTimer) {
            L.warn("Timer is already modified!");
            return;
        }
        if (defaultTimer != null) {
            this.defaultTps = this.getTicksPerSecond(defaultTimer);
        }
        float fps = ((Double)this.cfg.frameRate.get()).floatValue();
        float speed = ((Double)this.cfg.engineSpeed.get()).floatValue();
        this.setTimer(new FixedTimer(this.defaultTps, fps, speed));
    }

    @Override
    protected void doDisable() {
        if (!(this.getTimer() instanceof FixedTimer)) {
            L.warn("Timer is already restored!");
            return;
        }
        this.setTimer(new Timer(this.defaultTps));
    }

    private Timer getTimer() {
        try {
            return (Timer)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)MC, (String[])PrivateFields.MINECRAFT_TIMER);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't get timer", ex);
        }
    }

    private void setTimer(Timer timer) {
        try {
            ReflectionHelper.setPrivateValue(Minecraft.class, (Object)MC, (Object)timer, (String[])PrivateFields.MINECRAFT_TIMER);
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't set timer", ex);
        }
    }

    private float getTicksPerSecond(Timer timer) {
        try {
            return ((Float)ReflectionHelper.getPrivateValue(Timer.class, (Object)timer, (String[])PrivateFields.TIMER_TICKSPERSECOND)).floatValue();
        }
        catch (Exception ex) {
            L.warn("Can't get default ticks per second", (Throwable)ex);
            return 20.0f;
        }
    }
}

