/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.client.util;

import info.ata4.minecraft.minema.client.config.MinemaConfig;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CaptureTime {
    private static final Map<TimeUnit, String> TU_SUFFIX;
    private final MinemaConfig cfg;
    private final long startTime;
    private long currentFrameTime;
    private long prevFrameTime;
    private long nanosPerFrame;
    private int frames;

    public static String getTimeUnit(long nanos) {
        TimeUnit tu = null;
        TimeUnit[] tus = TimeUnit.values();
        long time = nanos;
        for (int i = tus.length - 1; i >= 0 && (time = (tu = tus[i]).convert(nanos, TimeUnit.NANOSECONDS)) <= 1L; --i) {
        }
        return time + TU_SUFFIX.get((Object)tu);
    }

    public static String getTimeStringFull(long nanos) {
        long hours = TimeUnit.NANOSECONDS.toHours(nanos);
        long minutes = TimeUnit.NANOSECONDS.toMinutes(nanos) - TimeUnit.HOURS.toMinutes(hours);
        long seconds = TimeUnit.NANOSECONDS.toSeconds(nanos) - TimeUnit.MINUTES.toSeconds(minutes) - TimeUnit.HOURS.toSeconds(hours);
        long milis = TimeUnit.NANOSECONDS.toMillis(nanos) - TimeUnit.SECONDS.toMillis(seconds) - TimeUnit.MINUTES.toMillis(minutes) - TimeUnit.HOURS.toMillis(hours);
        return String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, milis);
    }

    public static String getTimeStringSimple(long nanos) {
        long hours = TimeUnit.NANOSECONDS.toHours(nanos);
        long minutes = TimeUnit.NANOSECONDS.toMinutes(nanos) - TimeUnit.HOURS.toMinutes(hours);
        long seconds = TimeUnit.NANOSECONDS.toSeconds(nanos) - TimeUnit.MINUTES.toSeconds(minutes) - TimeUnit.HOURS.toSeconds(hours);
        return String.format("%dh %dm %ds", hours, minutes, seconds);
    }

    public CaptureTime(MinemaConfig cfg) {
        this.cfg = cfg;
        this.nanosPerFrame = (long)((double)TimeUnit.SECONDS.toNanos(1L) / (Double)cfg.frameRate.get());
        this.currentFrameTime = this.prevFrameTime = System.nanoTime();
        this.startTime = this.prevFrameTime;
    }

    public void nextFrame() {
        this.prevFrameTime = this.currentFrameTime;
        this.currentFrameTime = System.nanoTime();
        ++this.frames;
    }

    public int getNumFrames() {
        return this.frames;
    }

    public boolean isAtFrameLimit() {
        int frameLimit = (Integer)this.cfg.frameLimit.get();
        return frameLimit > 0 && this.frames > frameLimit;
    }

    public boolean isNextFrame() {
        return this.getTimeSincePreviousFrame() >= this.nanosPerFrame;
    }

    public long getPreviousCaptureTime() {
        return this.currentFrameTime - this.prevFrameTime;
    }

    public long getTimeSincePreviousFrame() {
        return System.nanoTime() - this.prevFrameTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getRealTime() {
        return System.nanoTime() - this.startTime;
    }

    public String getRealTimeString() {
        return CaptureTime.getTimeStringFull(this.getRealTime());
    }

    public long getVideoTime() {
        return (long)this.frames * this.nanosPerFrame;
    }

    public String getVideoTimeString() {
        return CaptureTime.getTimeStringFull(this.getVideoTime());
    }

    public double getAverageFPS() {
        return (double)TimeUnit.SECONDS.toNanos(1L) / ((double)this.getRealTime() / (double)this.getNumFrames());
    }

    static {
        EnumMap<TimeUnit, String> tuSuffix = new EnumMap<TimeUnit, String>(TimeUnit.class);
        tuSuffix.put(TimeUnit.DAYS, "d");
        tuSuffix.put(TimeUnit.HOURS, "h");
        tuSuffix.put(TimeUnit.MINUTES, "m");
        tuSuffix.put(TimeUnit.SECONDS, "s");
        tuSuffix.put(TimeUnit.MILLISECONDS, "ms");
        tuSuffix.put(TimeUnit.MICROSECONDS, "\u00c2\u00b5s");
        tuSuffix.put(TimeUnit.NANOSECONDS, "ns");
        TU_SUFFIX = Collections.unmodifiableMap(tuSuffix);
    }
}

