/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.util.config;

import info.ata4.minecraft.minema.util.config.ConfigValue;
import net.minecraftforge.common.config.Property;

public class ConfigEnum<T extends Enum>
extends ConfigValue<T> {
    private final Class<T> type;
    private final String[] validValues;

    public ConfigEnum(T value) {
        super(value);
        this.type = value.getClass();
        Enum[] values = (Enum[])this.type.getEnumConstants();
        this.validValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.validValues[i] = this.enumToString(values[i]);
        }
    }

    private String enumToString(T e) {
        return ((Enum)e).name().toLowerCase();
    }

    private T stringToEnum(String name) {
        return Enum.valueOf(this.type, name.toUpperCase());
    }

    @Override
    public Property.Type getPropType() {
        return Property.Type.STRING;
    }

    @Override
    public void importProp(Property prop) {
        try {
            this.set(this.stringToEnum(prop.getString()));
        }
        catch (IllegalArgumentException ex) {
            this.set(this.getDefault());
        }
    }

    @Override
    public void exportProp(Property prop) {
        prop.set(this.enumToString((Enum)this.get()));
        prop.setDefaultValue(this.enumToString((Enum)this.getDefault()));
        prop.setValidValues(this.validValues);
    }
}

