/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.util.config;

import info.ata4.minecraft.minema.util.config.ConfigValue;

public abstract class ConfigNumber<T extends Number>
extends ConfigValue<T> {
    private final T min;
    private final T max;

    public ConfigNumber(T value, T min, T max) {
        super(value);
        this.min = min;
        this.max = max;
    }

    public ConfigNumber(T value, T min) {
        this(value, min, null);
    }

    @Override
    public void set(T value) {
        if (this.min != null && ((Comparable)this.min).compareTo(value) > 0) {
            super.set(this.min);
        } else if (this.max != null && ((Comparable)this.max).compareTo(value) < 0) {
            super.set(this.max);
        } else {
            super.set(value);
        }
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }
}

