/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.minema.util.config;

import info.ata4.minecraft.minema.util.config.ConfigString;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.Validate;
import scala.actors.threadpool.Arrays;

public class ConfigStringEnum
extends ConfigString {
    private final Set<String> choices;
    private final String[] validValues;

    public ConfigStringEnum(String value, Set<String> choices) {
        super(value);
        Validate.notEmpty(choices);
        if (!choices.contains(value)) {
            throw new IllegalArgumentException();
        }
        this.choices = Collections.unmodifiableSet(choices);
        this.validValues = choices.toArray(new String[0]);
    }

    public ConfigStringEnum(String value, String ... choices) {
        this(value, new HashSet<String>(Arrays.asList((Object[])choices)));
    }

    public Set<String> getChoices() {
        return this.choices;
    }

    @Override
    public Property.Type getPropType() {
        return Property.Type.STRING;
    }

    @Override
    public void set(String value) {
        if (!this.choices.contains(value)) {
            super.set(this.getDefault());
        } else {
            super.set(value);
        }
    }

    @Override
    public void exportProp(Property prop) {
        super.exportProp(prop);
        prop.setValidValues(this.validValues);
    }
}

