/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.network;

import com.blocklings.entities.EntityBlockling;
import com.blocklings.main.Blocklings;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BlocklingLevelMessage
implements IMessage {
    private int entityID;
    private int level;

    public BlocklingLevelMessage() {
    }

    public BlocklingLevelMessage(int entityID, int level) {
        this.entityID = entityID;
        this.level = level;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.level = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.level);
    }

    public static class Handler
    implements IMessageHandler<BlocklingLevelMessage, IMessage> {
        public IMessage onMessage(BlocklingLevelMessage message, MessageContext ctx) {
            Entity entity = null;
            if (ctx.side.isClient()) {
                entity = Blocklings.proxy.getPlayerEntity((MessageContext)ctx).field_70170_p.func_73045_a(message.entityID);
            }
            if (entity instanceof EntityBlockling) {
                EntityBlockling blockling = (EntityBlockling)entity;
                blockling.setLevel(message.level);
            }
            return null;
        }
    }
}

