/*
 * Decompiled with CFR 0.152.
 */
package com.lucidsage.morebows.item;

import com.lucidsage.morebows.behavior.BasicBowBehavior;
import com.lucidsage.morebows.behavior.IBowBehavior;
import com.lucidsage.morebows.item.IItemToRegister;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Bow
extends ItemBow
implements IItemToRegister {
    String name;
    Object[] recipe;
    int enchantability;
    double drawSpeedRelativeToVanilla;
    EnumRarity rarity;
    IBowBehavior behavior;
    String[] pullingModelNames = new String[3];

    public Bow(String inName, int damage, double inDrawSpeedRelativeToVanilla, int inEnchantability, EnumRarity inRarity, Object[] inRecipe) {
        this(inName, damage, inDrawSpeedRelativeToVanilla, inEnchantability, inRarity, new BasicBowBehavior(), inRecipe);
    }

    public Bow(String inName, int damage, double inDrawSpeedRelativeToVanilla, int inEnchantability, EnumRarity inRarity, IBowBehavior bowBehavior, Object[] inRecipe) {
        this.name = inName;
        this.recipe = inRecipe;
        this.drawSpeedRelativeToVanilla = inDrawSpeedRelativeToVanilla;
        this.enchantability = inEnchantability;
        this.rarity = inRarity;
        this.behavior = bowBehavior;
        this.func_77656_e(damage);
        this.func_77655_b(this.name);
    }

    @Override
    public void init() {
        GameRegistry.registerItem((Item)this, (String)this.name);
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1), (Object[])this.recipe);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientInit(ItemModelMesher itemModelMesher) {
        String baseModelName = "morebows:" + this.name;
        ModelBakery.addVariantName((Item)this, (String[])new String[]{baseModelName});
        itemModelMesher.func_178086_a((Item)this, 0, new ModelResourceLocation(baseModelName, "inventory"));
        for (int i = 0; i < 3; ++i) {
            String variantName;
            this.pullingModelNames[i] = variantName = baseModelName + "_pulling_" + Integer.toString(i);
            ModelResourceLocation pullingModel = new ModelResourceLocation(variantName, "inventory");
            ModelBakery.addVariantName((Item)this, (String[])new String[]{variantName});
            itemModelMesher.func_178086_a((Item)this, i + 1, pullingModel);
        }
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        if (useRemaining < 1) {
            return null;
        }
        double vanillaTimeToFullPull = 18.0;
        double timeToFullPull = vanillaTimeToFullPull * this.drawSpeedRelativeToVanilla;
        double usedSoFar = this.func_77626_a(stack) - useRemaining;
        String variantName = this.pullingModelNames[Math.min((int)Math.floor(usedSoFar / timeToFullPull * 2.0), 2)];
        return new ModelResourceLocation(variantName, "inventory");
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityPlayer playerIn, int timeLeft) {
        int timeUsed = this.func_77626_a(stack) - timeLeft;
        ArrowLooseEvent event = new ArrowLooseEvent(playerIn, stack, timeUsed);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        timeUsed = event.charge;
        this.behavior.Firing(stack, worldIn, playerIn, timeUsed, (Item)this, this.drawSpeedRelativeToVanilla);
    }
}

