/*
 * Decompiled with CFR 0.152.
 */
package com.arc.sleep;

import java.io.File;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="Sleep", version="0.0-1", name="Sleep", acceptedMinecraftVersions="[1.8]")
public class Sleep {
    public static final String MODID = "Sleep";
    public static final String VERSION = "0.0-1";
    public static Configuration configuration;
    public static String configCategory;
    public static boolean regen;
    public static int regenSeconds;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configInit(new File(event.getModConfigurationDirectory(), "Sleep.cfg"));
        MinecraftForge.EVENT_BUS.register((Object)new SleepEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configInit(File file) {
        configuration = new Configuration(file);
        try {
            Sleep.syncConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            configuration.save();
        }
    }

    public static void syncConfig() {
        configuration.addCustomCategoryComment(configCategory, "Toggle regeneration instead of instant health (true for on)");
        regen = configuration.get(configCategory, "Regeneration allowed?", true).getBoolean(regen);
        regenSeconds = configuration.get(configCategory, "Total time (seconds) regen lasts", 5).getInt(regenSeconds);
        configuration.save();
    }

    static {
        configCategory = "Toggle Regeneration";
    }

    public class SleepEvent {
        @SubscribeEvent
        public void sleepEvent(PlayerWakeUpEvent event) {
            if (event.entityPlayer != null && event.entityPlayer.func_110143_aJ() < event.entityPlayer.func_110138_aP()) {
                if (regen) {
                    event.entityPlayer.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, regenSeconds * 20, 1));
                } else {
                    event.entityPlayer.func_70606_j(event.entityPlayer.func_110138_aP());
                }
            }
        }
    }
}

