/*
 * Decompiled with CFR 0.152.
 */
package com.asaskevich.smartcursor;

import com.asaskevich.smartcursor.Modules;
import com.asaskevich.smartcursor.RenderHelper;
import com.asaskevich.smartcursor.api.IBlockProcessor;
import com.asaskevich.smartcursor.api.IDropProcessor;
import com.asaskevich.smartcursor.render.RenderEntity;
import com.asaskevich.smartcursor.render.RenderPlayer;
import com.asaskevich.smartcursor.utils.EntityPonter;
import com.asaskevich.smartcursor.utils.Setting;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class RenderHandler {
    public Minecraft mc;
    public int width;
    public int height;
    public Field curBlockDamage;
    public ResourceLocation iconSheet = new ResourceLocation("minecraft:textures/gui/icons.png");
    private RenderPlayer renderPlayer;
    private RenderEntity renderEntity;
    private RenderItem itemRender;

    public RenderHandler(Minecraft mc) {
        this.mc = mc;
        this.width = mc.field_71443_c;
        this.height = mc.field_71440_d;
        this.renderPlayer = new RenderPlayer();
        this.renderEntity = new RenderEntity();
        this.itemRender = mc.func_175599_af();
        this.curBlockDamage = null;
        try {
            for (Field field : PlayerControllerMP.class.getDeclaredFields()) {
                if (!field.getName().equals("field_78770_f") && !field.getName().equals("curBlockDamageMP")) continue;
                this.curBlockDamage = PlayerControllerMP.class.getDeclaredField(field.getName());
                this.curBlockDamage.setAccessible(true);
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    @SubscribeEvent
    public void renderGameOverlay(RenderGameOverlayEvent event) {
        if (!Setting.isEnabled) {
            return;
        }
        try {
            this.itemRender = this.mc.func_175599_af();
            if (event.type == RenderGameOverlayEvent.ElementType.DEBUG) {
                ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
                FontRenderer fontRender = this.mc.field_71466_p;
                this.width = res.func_78326_a();
                this.height = res.func_78328_b();
                int y = this.height - fontRender.field_78288_b - 5;
                int x = 5;
                this.mc.field_71460_t.func_78478_c();
                int color = 0xFFFFFF;
                fontRender.func_175063_a("SmartCursor v1.5.0", (float)x, (float)y, color);
            } else if (event.type == RenderGameOverlayEvent.ElementType.TEXT) {
                MovingObjectPosition mop = this.mc.func_175606_aa().func_174822_a(15.0, 1.0f);
                BlockPos pos = mop.func_178782_a();
                EntityPonter.getEntityLookingAt(1.0f);
                if (mop != null) {
                    String text;
                    Block blockLookingAt = this.mc.field_71441_e.func_180495_p(pos).func_177230_c();
                    if (this.curBlockDamage != null) {
                        float damage = this.curBlockDamage.getFloat(Minecraft.func_71410_x().field_71442_b);
                        if (!Block.func_149680_a((Block)blockLookingAt, (Block)Blocks.field_150350_a) && damage > 0.0f) {
                            ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
                            FontRenderer fontRender = this.mc.field_71466_p;
                            this.width = res.func_78326_a();
                            this.height = res.func_78328_b();
                            int x = this.width / 2 + 4;
                            int y = this.height / 2 + 2;
                            if (Setting.blockDamageStyle == 0) {
                                this.mc.field_71460_t.func_78478_c();
                                text = String.format("%.1f%%", Float.valueOf(damage * 100.0f));
                                int color = 0xFFFFFF;
                                fontRender.func_175063_a(text, (float)x, (float)y, color);
                            } else if (Setting.blockDamageStyle == 1) {
                                x = this.width / 2 + 4;
                                y = this.height / 2 + 4;
                                Gui.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 31), (int)(y + fontRender.field_78288_b / 2 + 1), (int)-2293760);
                                Gui.func_73734_a((int)x, (int)y, (int)(x + (int)(damage * 30.0f)), (int)(y + fontRender.field_78288_b / 2), (int)-16720640);
                            }
                        }
                    }
                    if (this.mc.field_71476_x.field_72308_g == null && !Block.func_149680_a((Block)blockLookingAt, (Block)Blocks.field_150350_a) && Setting.showBlockInformation) {
                        int i;
                        EntityPonter.pointedEntity = null;
                        int color = 0xFFFFFF;
                        int x = 4;
                        int y = 4;
                        ArrayList<String> list = new ArrayList<String>();
                        int meta = blockLookingAt.func_176201_c(this.mc.field_71441_e.func_180495_p(pos));
                        Item item = blockLookingAt.func_180665_b((World)this.mc.field_71441_e, pos);
                        ItemStack stack = new ItemStack(blockLookingAt);
                        if (item != null) {
                            stack = new ItemStack(blockLookingAt.func_180665_b((World)this.mc.field_71441_e, pos));
                        }
                        stack.func_77964_b(meta);
                        list.add(EnumChatFormatting.BOLD + "" + EnumChatFormatting.GOLD + stack.func_82833_r() + EnumChatFormatting.RESET);
                        for (IBlockProcessor module : Modules.blockModules) {
                            if (!Modules.isActiveModule(module.getClass().getCanonicalName())) continue;
                            module.process(list, blockLookingAt, this.mc.field_71441_e.func_180495_p(pos), pos, (World)this.mc.field_71441_e);
                        }
                        ScaledResolution res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
                        FontRenderer fontRender = this.mc.field_71466_p;
                        this.width = res.func_78326_a();
                        this.height = res.func_78328_b();
                        this.mc.field_71460_t.func_78478_c();
                        int maxW = 0;
                        maxW = Math.max(maxW, fontRender.func_78256_a((String)list.get(0)) + 16);
                        for (i = 1; i < list.size(); ++i) {
                            maxW = Math.max(maxW, fontRender.func_78256_a((String)list.get(i)) + 8);
                        }
                        if (Setting.showTooltipInRightCorner) {
                            x = this.width - maxW;
                        }
                        RenderHelper.drawRect(x - 5, 0, x + maxW + 1, 8 + fontRender.field_78288_b * list.size() + 1 + 8, 0x555555, Setting.transparent);
                        RenderHelper.drawRect(x - 4, 0, x + maxW, 8 + fontRender.field_78288_b * list.size() + 8, 65825, Setting.transparent);
                        this.renderItem(stack, 0, x, y, 1.0f);
                        fontRender.func_175063_a((String)list.get(0), (float)(x + 20), (float)(y + 4), color);
                        for (i = 1; i < list.size(); ++i) {
                            fontRender.func_175063_a((String)list.get(i), (float)x, (float)(y + 8 + fontRender.field_78288_b * i), color);
                        }
                    } else if (EntityPonter.pointedEntity != null) {
                        int y;
                        int x;
                        ScaledResolution res;
                        Entity target = EntityPonter.pointedEntity;
                        if (target instanceof EntityPlayer && Setting.showPlayerInformation) {
                            EntityPlayer player = (EntityPlayer)target;
                            this.renderPlayer.render(player, this);
                        }
                        if (target instanceof EntityLiving) {
                            EntityLiving entity = (EntityLiving)target;
                            this.renderEntity.render(entity, this);
                        }
                        if (target instanceof EntityItem && Setting.showDropInformation) {
                            EntityItem item = (EntityItem)target;
                            res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
                            FontRenderer fontRender = this.mc.field_71466_p;
                            this.width = res.func_78326_a();
                            this.height = res.func_78328_b();
                            this.mc.field_71460_t.func_78478_c();
                            if (Setting.dropStyle == 0) {
                                int color = 0xFFFFFF;
                                text = item.func_92059_d().field_77994_a + "x " + item.func_92059_d().func_82833_r();
                                NBTTagList enchs = item.func_92059_d().func_77986_q();
                                if (enchs != null && Setting.showEnchantments) {
                                    for (int i = 0; i < enchs.func_74745_c(); ++i) {
                                        NBTTagCompound tag = enchs.func_150305_b(i);
                                        short id = tag.func_74765_d("id");
                                        short lvl = tag.func_74765_d("lvl");
                                        Enchantment e = Enchantment.func_180306_c((int)id);
                                        String enStr = e.func_77316_c((int)lvl);
                                        int x2 = this.width / 2 + 4;
                                        int y2 = this.height / 2 + 2 + fontRender.field_78288_b * i;
                                        fontRender.func_175063_a(enStr, (float)x2, (float)y2, color);
                                    }
                                }
                                int x3 = this.width / 2 - 4 - fontRender.func_78256_a(text);
                                int y3 = this.height / 2 - 2 - fontRender.field_78288_b;
                                fontRender.func_175063_a(text, (float)x3, (float)y3, color);
                                if (Setting.showDurability) {
                                    int maxDamage = item.func_92059_d().func_77958_k();
                                    int damage = item.func_92059_d().func_77952_i();
                                    if (damage > 0 && maxDamage > 0 && maxDamage - damage > 0) {
                                        x3 = this.width / 2 + 4;
                                        y3 = this.height / 2 - 2 - fontRender.field_78288_b;
                                        text = String.format("%d/%d", maxDamage - damage, maxDamage);
                                        fontRender.func_175063_a(text, (float)x3, (float)y3, color);
                                    }
                                }
                            } else {
                                int i;
                                ItemStack it = item.func_92059_d();
                                int color = 0xFFFFFF;
                                x = 4;
                                y = 4;
                                ArrayList<String> list = new ArrayList<String>();
                                list.add("");
                                int maxDamage = item.func_92059_d().func_77958_k();
                                int damage = item.func_92059_d().func_77952_i();
                                String text2 = "";
                                text2 = damage > 0 && maxDamage > 0 && maxDamage - damage > 0 ? String.format(EnumChatFormatting.BOLD + "" + EnumChatFormatting.GOLD + "%s:" + EnumChatFormatting.RESET + " %d/%d", it.func_82833_r(), maxDamage - damage, maxDamage) : EnumChatFormatting.BOLD + "" + EnumChatFormatting.GOLD + it.func_82833_r() + EnumChatFormatting.RESET;
                                list.add(StatCollector.func_74838_a((String)"smartcursor.item.count") + it.field_77994_a);
                                for (IDropProcessor module : Modules.dropModules) {
                                    if (!Modules.isActiveModule(module.getClass().getCanonicalName())) continue;
                                    module.process(list, it);
                                }
                                int maxW = 0;
                                maxW = Math.max(maxW, fontRender.func_78256_a(text2) + 16);
                                for (i = 1; i < list.size(); ++i) {
                                    maxW = Math.max(maxW, fontRender.func_78256_a((String)list.get(i)) + 8);
                                }
                                if (Setting.showTooltipInRightCorner) {
                                    x = this.width - maxW;
                                }
                                RenderHelper.drawRect(x - 5, 0, x + maxW + 1, 8 + fontRender.field_78288_b * list.size() + 1 + 8, 0x555555, Setting.transparent);
                                RenderHelper.drawRect(x - 4, 0, x + maxW, 8 + fontRender.field_78288_b * list.size() + 8, 65825, Setting.transparent);
                                this.renderItem(it, 0, x, y, 1.0f);
                                for (i = 1; i < list.size(); ++i) {
                                    fontRender.func_175063_a((String)list.get(i), (float)x, (float)(y + 8 + fontRender.field_78288_b * i), color);
                                }
                                fontRender.func_175063_a(text2, (float)(x + 20), (float)(y + 4), color);
                            }
                        }
                        if (target instanceof EntityXPOrb && Setting.showXPOrb) {
                            EntityXPOrb xp = (EntityXPOrb)target;
                            res = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
                            FontRenderer fontRender = this.mc.field_71466_p;
                            this.width = res.func_78326_a();
                            this.height = res.func_78328_b();
                            this.mc.field_71460_t.func_78478_c();
                            int color = 0xFFFFFF;
                            String text3 = xp.field_70530_e + " XP";
                            x = this.width / 2 - 4 - fontRender.func_78256_a(text3);
                            y = this.height / 2 + 2;
                            fontRender.func_175063_a(text3, (float)x, (float)y, color);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error");
            System.err.println(e);
            e.printStackTrace(System.out);
        }
    }

    public void renderItem(ItemStack itemstack, int slot, int x, int y, float partialTick) {
        if (itemstack != null) {
            GL11.glEnable((int)32826);
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            if (this.itemRender != null) {
                this.itemRender.func_180450_b(itemstack, x, y);
                this.itemRender.func_175030_a(this.mc.field_71466_p, itemstack, x, y);
            }
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
            GL11.glDisable((int)32826);
            GL11.glDisable((int)3042);
        }
    }

    public void invertRender() {
        Setting.isEnabled = !Setting.isEnabled;
    }

    public String getStyleName() {
        if (Setting.blockDamageStyle == 0) {
            return StatCollector.func_74838_a((String)"smartcursor.style.percents");
        }
        if (Setting.blockDamageStyle == 1) {
            return StatCollector.func_74838_a((String)"smartcursor.style.progressBar");
        }
        if (Setting.blockDamageStyle == 2) {
            return "OFF";
        }
        return "";
    }

    public void setNextStyle() {
        ++Setting.blockDamageStyle;
        Setting.blockDamageStyle %= 3;
    }

    public String getMobStyleName() {
        if (Setting.mobStyle == 0) {
            return StatCollector.func_74838_a((String)"smartcursor.style.numeric");
        }
        if (Setting.mobStyle == 1) {
            return StatCollector.func_74838_a((String)"smartcursor.style.progressBar");
        }
        if (Setting.mobStyle == 2) {
            return StatCollector.func_74838_a((String)"smartcursor.style.icons");
        }
        if (Setting.mobStyle == 3) {
            return "OFF";
        }
        return "";
    }

    public void setMobNextStyle() {
        ++Setting.mobStyle;
        Setting.mobStyle %= 4;
    }

    public void invertDropInfo() {
        Setting.showDropInformation = !Setting.showDropInformation;
    }

    public void invertEnchInfo() {
        Setting.showEnchantments = !Setting.showEnchantments;
    }

    public void invertDurInfo() {
        Setting.showDurability = !Setting.showDurability;
    }

    public String getDropStyleName() {
        if (Setting.dropStyle == 0) {
            return StatCollector.func_74838_a((String)"smartcursor.pos.center");
        }
        if (Setting.dropStyle == 1) {
            return StatCollector.func_74838_a((String)"smartcursor.pos.inCorner");
        }
        return "";
    }

    public void setDropNextStyle() {
        ++Setting.dropStyle;
        Setting.dropStyle %= 2;
    }

    public String getPlayerStyleName() {
        if (Setting.playerStyle == 0) {
            return StatCollector.func_74838_a((String)"smartcursor.pos.inCorner");
        }
        if (Setting.playerStyle == 1) {
            return StatCollector.func_74838_a((String)"smartcursor.style.numeric");
        }
        if (Setting.playerStyle == 2) {
            return StatCollector.func_74838_a((String)"smartcursor.style.progressBar");
        }
        if (Setting.playerStyle == 3) {
            return StatCollector.func_74838_a((String)"smartcursor.style.icons");
        }
        return "";
    }

    public void setPlayerNextStyle() {
        ++Setting.playerStyle;
        Setting.playerStyle %= 4;
    }

    public void invertXPInfo() {
        Setting.showXPOrb = !Setting.showXPOrb;
    }

    public void invertMobInfo() {
        Setting.displayAdvInfoMob = !Setting.displayAdvInfoMob;
    }

    public void invertBlockInfo() {
        Setting.showBlockInformation = !Setting.showBlockInformation;
    }

    public void invertPlayerInfo() {
        Setting.showPlayerInformation = !Setting.showPlayerInformation;
    }

    public void invertTooltipPlaceInfo() {
        Setting.showTooltipInRightCorner = !Setting.showTooltipInRightCorner;
    }

    @SubscribeEvent
    public void addTooltipText(ItemTooltipEvent event) {
        ItemStack stack = event.itemStack;
        event.toolTip.add(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "Unlocalized name:" + EnumChatFormatting.RESET + stack.func_77977_a());
    }
}

