/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.samsapples;

import com.lothrazar.samsapples.ModApples;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFoodAppleMagic
extends ItemFood {
    private boolean hasEffect = false;
    private ArrayList<Integer> potionIds;
    private ArrayList<Integer> potionDurations;
    private ArrayList<Integer> potionAmplifiers;

    public ItemFoodAppleMagic(int fillsHunger, boolean has_effect) {
        super(fillsHunger, false);
        this.hasEffect = has_effect;
        this.func_77848_i();
        this.func_77637_a(ModApples.tabSamsContent);
        this.potionIds = new ArrayList();
        this.potionDurations = new ArrayList();
        this.potionAmplifiers = new ArrayList();
    }

    public ItemFoodAppleMagic addEffect(int potionId, int potionDuration, int potionAmplifier) {
        int TICKS_PER_SEC = 20;
        this.potionIds.add(potionId);
        this.potionDurations.add(potionDuration * TICKS_PER_SEC);
        this.potionAmplifiers.add(potionAmplifier);
        return this;
    }

    protected void func_77849_c(ItemStack par1ItemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            for (int i = 0; i < this.potionIds.size(); ++i) {
                ItemFoodAppleMagic.addOrMergePotionEffect(player, new PotionEffect(this.potionIds.get(i).intValue(), this.potionDurations.get(i).intValue(), this.potionAmplifiers.get(i).intValue()));
            }
        }
    }

    public boolean func_77636_d(ItemStack par1ItemStack) {
        return this.hasEffect;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        if (this.hasEffect) {
            return EnumRarity.EPIC;
        }
        return EnumRarity.RARE;
    }

    public static void addRecipe(ItemFoodAppleMagic apple, ItemStack ingredient) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)apple), (Object[])new Object[]{"lll", "lal", "lll", Character.valueOf('l'), ingredient, Character.valueOf('a'), Items.field_151034_e});
        GameRegistry.addSmelting((Item)apple, (ItemStack)new ItemStack(ingredient.func_77973_b(), 8, ingredient.func_77960_j()), (float)0.0f);
    }

    public void func_77624_a(ItemStack held, EntityPlayer player, List list, boolean par4) {
        for (int i = 0; i < this.potionIds.size(); ++i) {
            Potion p = Potion.field_76425_a[this.potionIds.get(i)];
            list.add(ModApples.lang(p.func_76393_a()));
        }
    }

    public static void addOrMergePotionEffect(EntityPlayer player, PotionEffect newp) {
        if (player.func_82165_m(newp.func_76456_a())) {
            PotionEffect p = player.func_70660_b(Potion.field_76425_a[newp.func_76456_a()]);
            int ampMax = Math.max(p.func_76458_c(), newp.func_76458_c());
            player.func_70690_d(new PotionEffect(newp.func_76456_a(), newp.func_76459_b() + p.func_76459_b(), ampMax));
        } else {
            player.func_70690_d(newp);
        }
    }
}

