/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.samsapples;

import com.lothrazar.samsapples.CommonProxy;
import com.lothrazar.samsapples.ItemRegistry;
import com.lothrazar.samsapples.PotionRegistry;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

@Mod(modid="samsapples", useMetadata=true, acceptedMinecraftVersions="[1.8]")
public class ModApples {
    public static final String MODID = "samsapples";
    public static final String TEXTURE_LOCATION = "samsapples:";
    @Mod.Instance(value="samsapples")
    public static ModApples instance;
    @SidedProxy(clientSide="com.lothrazar.samsapples.ClientProxy", serverSide="com.lothrazar.samsapples.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static CreativeTabs tabSamsContent;

    public static void playSoundAt(Entity player, String sound) {
        player.field_70170_p.func_72956_a(player, sound, 1.0f, 1.0f);
    }

    public static void spawnParticle(World world, EnumParticleTypes type, BlockPos pos) {
        if (pos != null) {
            ModApples.spawnParticle(world, type, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public static void spawnParticle(World world, EnumParticleTypes type, double x, double y, double z) {
        for (int countparticles = 0; countparticles <= 10; ++countparticles) {
            world.func_175688_a(type, x + (world.field_73012_v.nextDouble() - 0.5) * 0.8, y + world.field_73012_v.nextDouble() * 1.5 - 0.1, z + (world.field_73012_v.nextDouble() - 0.5) * 0.8, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        PotionRegistry.registerPotionEffects();
        ItemRegistry.registerItems();
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @SubscribeEvent
    public void onEnderTeleportEvent(EnderTeleportEvent event) {
        if (event.entityLiving != null && event.entityLiving.func_70644_a(PotionRegistry.ender)) {
            event.attackDamage = 0.0f;
            if (!event.entityLiving.field_70170_p.field_72995_K) {
                EntityItem entityItem = new EntityItem(event.entityLiving.field_70170_p, event.targetX, event.targetY, event.targetZ, new ItemStack(Items.field_151079_bi));
                event.entityLiving.field_70170_p.func_72838_d((Entity)entityItem);
            }
        }
    }

    public static String lang(String name) {
        return StatCollector.func_74838_a((String)name);
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        proxy.registerRenderers();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTextOverlay(RenderGameOverlayEvent.Text event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_82165_m(PotionRegistry.nav_id) && !Minecraft.func_71410_x().field_71474_y.field_74330_P && player.field_70170_p.field_72995_K) {
            int size = 16;
            int xLeft = 20;
            int xRight = Minecraft.func_71410_x().field_71443_c / 2 - size * 2;
            int yBottom = Minecraft.func_71410_x().field_71440_d / 2 - size * 2;
            ModApples.renderItemAt(new ItemStack(Items.field_151113_aN), xLeft, yBottom, size);
            ModApples.renderItemAt(new ItemStack(Items.field_151111_aL), xRight, yBottom, size);
            World world = null;
            if (MinecraftServer.func_71276_C().field_71305_c.length > 0) {
                world = MinecraftServer.func_71276_C().func_130014_f_();
            } else {
                System.out.println("worldServers do not exist");
            }
            if (this.isSlimeChunk(world, player.func_180425_c())) {
                ModApples.renderItemAt(new ItemStack(Items.field_151123_aH), xLeft + size + 1, yBottom, size);
            }
        }
    }

    private boolean isSlimeChunk(World world, BlockPos pos) {
        if (world == null) {
            return false;
        }
        long seed = world.func_72905_C();
        if (seed == 0L) {
            return false;
        }
        Chunk in = world.func_175726_f(pos);
        Random rnd = new Random(seed + (long)(in.field_76635_g * in.field_76635_g * 4987142) + (long)(in.field_76635_g * 5947611) + (long)(in.field_76647_h * in.field_76647_h) * 4392871L + (long)(in.field_76647_h * 389711) ^ 0x3AD8025FL);
        boolean isSlimeChunk = rnd.nextInt(10) == 0;
        return isSlimeChunk;
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderItemAt(ItemStack stack, int x, int y, int dim) {
        IBakedModel iBakedModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        TextureAtlasSprite textureAtlasSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(iBakedModel.func_177554_e().func_94215_i());
        ModApples.renderTexture(textureAtlasSprite, x, y, dim);
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTexture(TextureAtlasSprite textureAtlasSprite, int x, int y, int dim) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        int height = dim;
        int width = dim;
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_178970_b();
        worldrenderer.func_178985_a((double)x, (double)(y + height), 0.0, (double)textureAtlasSprite.func_94209_e(), (double)textureAtlasSprite.func_94210_h());
        worldrenderer.func_178985_a((double)(x + width), (double)(y + height), 0.0, (double)textureAtlasSprite.func_94212_f(), (double)textureAtlasSprite.func_94210_h());
        worldrenderer.func_178985_a((double)(x + width), (double)y, 0.0, (double)textureAtlasSprite.func_94212_f(), (double)textureAtlasSprite.func_94206_g());
        worldrenderer.func_178985_a((double)x, (double)y, 0.0, (double)textureAtlasSprite.func_94209_e(), (double)textureAtlasSprite.func_94206_g());
        tessellator.func_78381_a();
    }

    static {
        tabSamsContent = new CreativeTabs("tabSamsApples"){

            public Item func_78016_d() {
                return ItemRegistry.apple_chocolate;
            }
        };
    }
}

